/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.io.ReadWriteable;

@Reference(type=ReferenceType.Article, author={"Morel, Jean-Michel", "Yu, Guoshen"}, title="{ASIFT: A New Framework for Fully Affine Invariant Image Comparison}", year="2009", journal="SIAM J. Img. Sci.", publisher="Society for Industrial and Applied Mathematics")
public class AffineParams
implements ReadWriteable {
    public float theta;
    public float tilt;

    public AffineParams(float theta, float tilt) {
        this.theta = theta;
        this.tilt = tilt;
    }

    public AffineParams() {
    }

    public boolean equals(Object po) {
        if (po instanceof AffineParams) {
            AffineParams p = (AffineParams)po;
            return (double)Math.abs(this.theta - p.theta) < 1.0E-5 && (double)Math.abs(this.tilt - p.tilt) < 1.0E-5;
        }
        return false;
    }

    public int hashCode() {
        int hash = new Float(this.theta).hashCode() ^ new Float(this.tilt).hashCode();
        return hash;
    }

    public String toString() {
        return String.format("theta:%f tilt:%f", Float.valueOf(this.theta), Float.valueOf(this.tilt));
    }

    public void readBinary(DataInput in) throws IOException {
        this.theta = in.readFloat();
        this.tilt = in.readFloat();
    }

    public void readASCII(Scanner in) throws IOException {
        this.theta = in.nextFloat();
        this.tilt = in.nextFloat();
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public String asciiHeader() {
        return "";
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.theta);
        out.writeFloat(this.tilt);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(this.theta);
        out.println(this.tilt);
    }
}

