/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.histogram.BinnedWindowedExtractor;
import org.openimaj.math.statistics.distribution.Histogram;

public class InterpolatedBinnedWindowedExtractor
extends BinnedWindowedExtractor {
    float[][] weights;
    boolean wrap = false;

    public InterpolatedBinnedWindowedExtractor(int nbins) {
        super(nbins);
    }

    public InterpolatedBinnedWindowedExtractor(int nbins, boolean wrap) {
        super(nbins);
        this.wrap = true;
    }

    public InterpolatedBinnedWindowedExtractor(int nbins, float min, float max) {
        super(nbins, min, max);
    }

    public InterpolatedBinnedWindowedExtractor(int nbins, float min, float max, boolean wrap) {
        super(nbins, min, max);
        this.wrap = wrap;
    }

    @Override
    public void analyseImage(FImage image) {
        int height = image.height;
        int width = image.width;
        this.binMap = new int[height][width];
        this.weights = new float[height][width];
        if (this.wrap) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float val = (image.pixels[y][x] - this.min) / (this.max - this.min) * (float)this.nbins;
                    int bin = (int)Math.floor(val);
                    float delta = val - (float)bin;
                    int lbin = bin % this.nbins;
                    float lweight = 1.0f - delta;
                    this.binMap[y][x] = lbin;
                    this.weights[y][x] = lweight;
                }
            }
        } else {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    float lweight;
                    int lbin;
                    float val = (image.pixels[y][x] - this.min) / (this.max - this.min) * (float)this.nbins;
                    int bin = (int)Math.floor(val);
                    float delta = val - (float)bin;
                    if ((double)delta < 0.5) {
                        lbin = bin - 1;
                        lweight = 0.5f + delta;
                    } else {
                        lbin = bin;
                        lweight = 1.5f - delta;
                    }
                    if (lbin < 0) {
                        lbin = 0;
                        lweight = 1.0f;
                    } else if (bin >= this.nbins) {
                        lbin = this.nbins - 1;
                        lweight = 1.0f;
                    }
                    this.binMap[y][x] = lbin;
                    this.weights[y][x] = lweight;
                }
            }
        }
    }

    @Override
    public Histogram computeHistogram(int x, int y, int w, int h) {
        Histogram hist = new Histogram(this.nbins);
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + h);
        int stopx = Math.min(this.binMap[0].length, x + w);
        for (int r = starty; r < stopy; ++r) {
            for (int c = startx; c < stopx; ++c) {
                int bin = this.binMap[r][c];
                double[] dArray = (double[])hist.values;
                int n = bin;
                dArray[n] = dArray[n] + (double)this.weights[r][c];
                if (this.wrap && bin + 1 == this.nbins) {
                    double[] dArray2 = (double[])hist.values;
                    dArray2[0] = dArray2[0] + (double)(1.0f - this.weights[r][c]);
                }
                if (bin + 1 >= this.nbins) continue;
                double[] dArray3 = (double[])hist.values;
                int n2 = bin + 1;
                dArray3[n2] = dArray3[n2] + (double)(1.0f - this.weights[r][c]);
            }
        }
        return hist;
    }

    @Override
    public Histogram computeHistogram(int x, int y, int w, int h, FImage extWeights) {
        Histogram hist = new Histogram(this.nbins);
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + h);
        int stopx = Math.min(this.binMap[0].length, x + w);
        for (int r = starty; r < stopy; ++r) {
            for (int c = startx; c < stopx; ++c) {
                int bin = this.binMap[r][c];
                double[] dArray = (double[])hist.values;
                int n = bin;
                dArray[n] = dArray[n] + (double)(extWeights.pixels[r][c] * this.weights[r][c]);
                if (this.wrap && bin + 1 == this.nbins) {
                    double[] dArray2 = (double[])hist.values;
                    dArray2[0] = dArray2[0] + (double)(extWeights.pixels[r][c] * (1.0f - this.weights[r][c]));
                }
                if (bin + 1 >= this.nbins) continue;
                double[] dArray3 = (double[])hist.values;
                int n2 = bin + 1;
                dArray3[n2] = dArray3[n2] + (double)(extWeights.pixels[r][c] * (1.0f - this.weights[r][c]));
            }
        }
        return hist;
    }

    @Override
    public Histogram computeHistogram(int x, int y, FImage extWeights, FImage windowWeights) {
        Histogram hist = new Histogram(this.nbins);
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + windowWeights.height);
        int stopx = Math.min(this.binMap[0].length, x + windowWeights.width);
        int startwr = y < 0 ? -y : y;
        int startwc = x < 0 ? -x : x;
        int r = starty;
        int wr = startwr;
        while (r < stopy) {
            int c = startx;
            int wc = startwc;
            while (c < stopx) {
                int bin = this.binMap[r][c];
                double[] dArray = (double[])hist.values;
                int n = bin;
                dArray[n] = dArray[n] + (double)(extWeights.pixels[r][c] * this.weights[r][c] * windowWeights.pixels[wr][wc]);
                if (this.wrap && bin + 1 == this.nbins) {
                    double[] dArray2 = (double[])hist.values;
                    dArray2[0] = dArray2[0] + (double)(extWeights.pixels[r][c] * (1.0f - this.weights[r][c]) * windowWeights.pixels[wr][wc]);
                }
                if (bin + 1 < this.nbins) {
                    double[] dArray3 = (double[])hist.values;
                    int n2 = bin + 1;
                    dArray3[n2] = dArray3[n2] + (double)(extWeights.pixels[r][c] * (1.0f - this.weights[r][c]) * windowWeights.pixels[wr][wc]);
                }
                ++c;
                ++wc;
            }
            ++r;
            ++wr;
        }
        return hist;
    }

    public float[][] getWeightsMap() {
        return this.weights;
    }
}

