/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.convolution.AverageBoxFilter;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(type=ReferenceType.Inproceedings, author={"Kovesi, P."}, title="Fast Almost-Gaussian Filtering", year="2010", booktitle="Digital Image Computing: Techniques and Applications (DICTA), 2010 International Conference on", pages={"121", "125"}, month="Dec", customData={"keywords", "Gaussian processes;approximation theory;band-pass filters;image processing;Gaussian bandpass filters;fast almost-Gaussian filtering;image averaging;integral images;log-Gabor filters;separable moving average filters;summed area tables;symmetric transfer function;Approximation methods;Bandwidth;Computer vision;Frequency domain analysis;Laplace equations;Pixel;Transfer functions;Difference of Gaussian filtering;Gaussian smoothing", "doi", "10.1109/DICTA.2010.30"})
public class FFastGaussianConvolve
implements SinglebandImageProcessor<Float, FImage> {
    private final int n;
    private final int m;
    private SinglebandImageProcessor<Float, FImage> wlBox;
    private SinglebandImageProcessor<Float, FImage> wuBox;

    public FFastGaussianConvolve(float sigma, int n) {
        if ((double)sigma < 1.8) {
            this.m = 1;
            this.n = 1;
            this.wlBox = new FGaussianConvolve(sigma);
        } else {
            float ss = sigma * sigma;
            double wIdeal = Math.sqrt(12.0 * (double)ss / (double)n + 1.0);
            int wl = (int)wIdeal % 2 == 0 ? (int)wIdeal - 1 : (int)wIdeal;
            int wu = wl + 2;
            this.n = n;
            this.m = Math.round((12.0f * ss - (float)(n * wl * wl) - (float)(4 * n * wl) - (float)(3 * n)) / (float)(-4 * wl - 4));
            this.wlBox = new AverageBoxFilter(wl);
            this.wuBox = new AverageBoxFilter(wu);
        }
    }

    public void processImage(FImage image) {
        int i;
        for (i = 0; i < this.m; ++i) {
            this.wlBox.processImage((Image)image);
        }
        for (i = 0; i < this.n - this.m; ++i) {
            this.wuBox.processImage((Image)image);
        }
    }
}

