/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import odk.lang.FastMath;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class FImageGradients
implements ImageAnalyser<FImage> {
    private static final float PI_FLOAT = (float)Math.PI;
    private static final float PI_OVER_TWO_FLOAT = 1.5707964f;
    private static final float TWO_PI_FLOAT = (float)Math.PI * 2;
    public FImage magnitudes;
    public FImage orientations;
    public Mode mode;

    public FImageGradients() {
        this.mode = Mode.Signed;
    }

    public FImageGradients(Mode mode) {
        this.mode = mode;
    }

    public void analyseImage(FImage image) {
        if (this.magnitudes == null || this.magnitudes.height != image.height || this.magnitudes.width != image.width) {
            this.magnitudes = new FImage(image.width, image.height);
            this.orientations = new FImage(image.width, image.height);
        }
        this.mode.gradientMagnitudesAndOrientations(image, this.magnitudes, this.orientations);
    }

    public static FImageGradients getGradientMagnitudesAndOrientations(FImage image) {
        FImageGradients go = new FImageGradients();
        go.analyseImage(image);
        return go;
    }

    public static FImageGradients getGradientMagnitudesAndOrientations(FImage image, Mode mode) {
        FImageGradients go = new FImageGradients(mode);
        go.analyseImage(image);
        return go;
    }

    public static void gradientMagnitudesAndOrientations(FImage image, FImage magnitudes, FImage orientations) {
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                float xgrad = c == 0 ? 2.0f * (image.pixels[r][c + 1] - image.pixels[r][c]) : (c == image.width - 1 ? 2.0f * (image.pixels[r][c] - image.pixels[r][c - 1]) : image.pixels[r][c + 1] - image.pixels[r][c - 1]);
                float ygrad = r == 0 ? 2.0f * (image.pixels[r][c] - image.pixels[r + 1][c]) : (r == image.height - 1 ? 2.0f * (image.pixels[r - 1][c] - image.pixels[r][c]) : image.pixels[r - 1][c] - image.pixels[r + 1][c]);
                magnitudes.pixels[r][c] = (float)Math.sqrt(xgrad * xgrad + ygrad * ygrad);
                orientations.pixels[r][c] = (float)FastMath.atan2((double)ygrad, (double)xgrad);
            }
        }
    }

    public static void gradientMagnitudesAndUnsignedOrientations(FImage image, FImage magnitudes, FImage orientations) {
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                float xgrad = c == 0 ? 2.0f * (image.pixels[r][c + 1] - image.pixels[r][c]) : (c == image.width - 1 ? 2.0f * (image.pixels[r][c] - image.pixels[r][c - 1]) : image.pixels[r][c + 1] - image.pixels[r][c - 1]);
                float ygrad = r == 0 ? 2.0f * (image.pixels[r][c] - image.pixels[r + 1][c]) : (r == image.height - 1 ? 2.0f * (image.pixels[r - 1][c] - image.pixels[r][c]) : image.pixels[r - 1][c] - image.pixels[r + 1][c]);
                magnitudes.pixels[r][c] = (float)Math.sqrt(xgrad * xgrad + ygrad * ygrad);
                orientations.pixels[r][c] = magnitudes.pixels[r][c] == 0.0f ? 0.0f : (float)FastMath.atan((double)(ygrad / xgrad));
            }
        }
    }

    public static void gradientMagnitudesAndQuantisedOrientations(FImage image, FImage[] magnitudes) {
        int numOriBins = magnitudes.length;
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                float f;
                float xgrad = c == 0 ? 2.0f * (image.pixels[r][c + 1] - image.pixels[r][c]) : (c == image.width - 1 ? 2.0f * (image.pixels[r][c] - image.pixels[r][c - 1]) : image.pixels[r][c + 1] - image.pixels[r][c - 1]);
                float ygrad = r == 0 ? 2.0f * (image.pixels[r][c] - image.pixels[r + 1][c]) : (r == image.height - 1 ? 2.0f * (image.pixels[r - 1][c] - image.pixels[r][c]) : image.pixels[r - 1][c] - image.pixels[r + 1][c]);
                float mag = (float)Math.sqrt(xgrad * xgrad + ygrad * ygrad);
                float ori = (float)FastMath.atan2((double)ygrad, (double)xgrad);
                ori = f >= 0.0f ? ori : (ori %= (float)Math.PI * 2) + (float)Math.PI * 2;
                float po = (float)numOriBins * ori / ((float)Math.PI * 2);
                int oi = (int)Math.floor(po);
                float of = po - (float)oi;
                for (int i = 0; i < magnitudes.length; ++i) {
                    magnitudes[i].pixels[r][c] = 0.0f;
                }
                magnitudes[oi % numOriBins].pixels[r][c] = (1.0f - of) * mag;
                magnitudes[(oi + 1) % numOriBins].pixels[r][c] = of * mag;
            }
        }
    }

    public static void gradientMagnitudesAndQuantisedOrientations(FImage image, FImage[] magnitudes, boolean interp, Mode mode) {
        int numOriBins = magnitudes.length;
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                float po;
                float ori;
                float xgrad = c == 0 ? 2.0f * (image.pixels[r][c + 1] - image.pixels[r][c]) : (c == image.width - 1 ? 2.0f * (image.pixels[r][c] - image.pixels[r][c - 1]) : image.pixels[r][c + 1] - image.pixels[r][c - 1]);
                float ygrad = r == 0 ? 2.0f * (image.pixels[r][c] - image.pixels[r + 1][c]) : (r == image.height - 1 ? 2.0f * (image.pixels[r - 1][c] - image.pixels[r][c]) : image.pixels[r - 1][c] - image.pixels[r + 1][c]);
                float mag = (float)Math.sqrt(xgrad * xgrad + ygrad * ygrad);
                if (mode == Mode.Unsigned) {
                    ori = mag == 0.0f ? 1.5707964f : (float)FastMath.atan((double)(ygrad / xgrad)) + 1.5707964f;
                    po = (float)numOriBins * ori / (float)Math.PI;
                } else {
                    float f;
                    ori = (float)FastMath.atan2((double)ygrad, (double)xgrad);
                    ori = f >= 0.0f ? ori : (ori %= (float)Math.PI * 2) + (float)Math.PI * 2;
                    po = (float)numOriBins * ori / ((float)Math.PI * 2);
                }
                for (int i = 0; i < magnitudes.length; ++i) {
                    magnitudes[i].pixels[r][c] = 0.0f;
                }
                int oi = (int)Math.floor(po);
                float of = po - (float)oi;
                if (interp) {
                    magnitudes[oi % numOriBins].pixels[r][c] = (1.0f - of) * mag;
                    magnitudes[(oi + 1) % numOriBins].pixels[r][c] = of * mag;
                    continue;
                }
                if (oi > numOriBins - 1) {
                    oi = numOriBins - 1;
                }
                magnitudes[oi].pixels[r][c] = mag;
            }
        }
    }

    public static enum Mode {
        Unsigned(-1.5707964f, 1.5707964f){

            @Override
            void gradientMagnitudesAndOrientations(FImage image, FImage magnitudes, FImage orientations) {
                FImageGradients.gradientMagnitudesAndUnsignedOrientations(image, magnitudes, orientations);
            }
        }
        ,
        Signed((float)(-Math.PI), (float)Math.PI){

            @Override
            void gradientMagnitudesAndOrientations(FImage image, FImage magnitudes, FImage orientations) {
                FImageGradients.gradientMagnitudesAndOrientations(image, magnitudes, orientations);
            }
        };

        private float min;
        private float max;

        private Mode(float min, float max) {
            this.min = min;
            this.max = max;
        }

        abstract void gradientMagnitudesAndOrientations(FImage var1, FImage var2, FImage var3);

        public float minAngle() {
            return this.min;
        }

        public float maxAngle() {
            return this.max;
        }
    }
}

