/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution;

import org.openimaj.image.FImage;
import org.openimaj.image.processor.SinglebandKernelProcessor;

public class FSobelMagnitude
implements SinglebandKernelProcessor<Float, FImage> {
    public static final FImage KERNEL_X = new FImage((float[][])new float[][]{{1.0f, 0.0f, -1.0f}, {2.0f, 0.0f, -2.0f}, {1.0f, 0.0f, -1.0f}});
    public static final FImage KERNEL_Y = new FImage((float[][])new float[][]{{1.0f, 2.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, -2.0f, -1.0f}});

    public int getKernelHeight() {
        return 3;
    }

    public int getKernelWidth() {
        return 3;
    }

    public Float processKernel(FImage patch) {
        float sumx = 0.0f;
        float sumy = 0.0f;
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                sumx += FSobelMagnitude.KERNEL_X.pixels[2 - r][2 - c] * patch.pixels[r][c];
                sumy += FSobelMagnitude.KERNEL_Y.pixels[2 - r][2 - c] * patch.pixels[r][c];
            }
        }
        return Float.valueOf((float)Math.sqrt(sumx * sumx + sumy * sumy));
    }
}

