/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FConvolution;
import org.openimaj.image.processing.convolution.filterbank.FilterBank;
import org.openimaj.image.processing.convolution.filterbank.LeungMalikFilterBank;

public class SchmidFilterBank
extends FilterBank {
    public SchmidFilterBank() {
        this(49);
    }

    public SchmidFilterBank(int size) {
        super(SchmidFilterBank.makeFilters(size));
    }

    protected static FConvolution[] makeFilters(int SUP) {
        FConvolution[] F = new FConvolution[]{SchmidFilterBank.makeFilter(SUP, 2.0f, 1.0f), SchmidFilterBank.makeFilter(SUP, 4.0f, 1.0f), SchmidFilterBank.makeFilter(SUP, 4.0f, 2.0f), SchmidFilterBank.makeFilter(SUP, 6.0f, 1.0f), SchmidFilterBank.makeFilter(SUP, 6.0f, 2.0f), SchmidFilterBank.makeFilter(SUP, 6.0f, 3.0f), SchmidFilterBank.makeFilter(SUP, 8.0f, 1.0f), SchmidFilterBank.makeFilter(SUP, 8.0f, 2.0f), SchmidFilterBank.makeFilter(SUP, 8.0f, 3.0f), SchmidFilterBank.makeFilter(SUP, 10.0f, 1.0f), SchmidFilterBank.makeFilter(SUP, 10.0f, 2.0f), SchmidFilterBank.makeFilter(SUP, 10.0f, 3.0f), SchmidFilterBank.makeFilter(SUP, 10.0f, 4.0f)};
        return F;
    }

    private static FConvolution makeFilter(int sup, float sigma, float tau) {
        int hs = (sup - 1) / 2;
        FImage filter = new FImage(sup, sup);
        int y = -hs;
        int j = 0;
        while (y < hs) {
            int x = -hs;
            int i = 0;
            while (x < hs) {
                float r = (float)Math.sqrt(x * x + y * y);
                filter.pixels[j][i] = (float)(Math.cos((double)r * (Math.PI * (double)tau / (double)sigma)) * Math.exp(-(r * r) / (2.0f * sigma * sigma)));
                ++x;
                ++i;
            }
            ++y;
            ++j;
        }
        return new FConvolution(LeungMalikFilterBank.normalise(filter));
    }
}

