/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.math.geometry.point.Point2d;

public class Feature
implements Point2d,
Cloneable {
    public float x;
    public float y;
    public int val;

    public String toString(String format, String type) {
        assert (type.equals("f") || type.equals("d"));
        String s = "";
        if (type.equals("f")) {
            s = s + String.format(format, Float.valueOf(this.x), Float.valueOf(this.y), this.val);
        } else if (type.equals("d")) {
            float _x = this.x;
            float _y = this.y;
            if ((double)_x >= 0.0) {
                _x = (float)((double)_x + 0.5);
            }
            if ((double)_y >= 0.0) {
                _y = (float)((double)_y + 0.5);
            }
            s = s + String.format(format, (int)this.x, (int)this.y, this.val);
        }
        return s;
    }

    public void writeFeatureBin(DataOutputStream os) throws IOException {
        os.writeFloat(this.x);
        os.writeFloat(this.y);
        os.writeInt(this.val);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public Feature clone() {
        Feature f = new Feature();
        f.x = this.x;
        f.y = this.y;
        f.val = this.val;
        return f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        return ((Feature)o).x == this.x && ((Feature)o).y == this.y && ((Feature)o).val == this.val;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((float)(31 * hash) + this.x);
        hash = (int)((float)(31 * hash) + this.y);
        hash = 31 * hash + this.val;
        return hash;
    }

    public String toString() {
        return "Feature(" + this.x + ", " + this.y + ", " + this.val + ")";
    }

    public void copyFrom(Point2d p) {
        this.setX(p.getX());
        this.setY(p.getY());
    }

    public Float getOrdinate(int dimension) {
        if (dimension == 0) {
            return Float.valueOf(this.x);
        }
        return Float.valueOf(this.y);
    }

    public int getDimensions() {
        return 2;
    }

    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    public Feature transform(Matrix transform) {
        if (transform.getRowDimension() == 3) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY() + (float)transform.get(0, 2);
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY() + (float)transform.get(1, 2);
            float zt = (float)transform.get(2, 0) * this.getX() + (float)transform.get(2, 1) * this.getY() + (float)transform.get(2, 2);
            Feature f = this.clone();
            f.x = xt /= zt;
            f.y = yt /= zt;
            return f;
        }
        if (transform.getRowDimension() == 2) {
            float xt = (float)transform.get(0, 0) * this.getX() + (float)transform.get(0, 1) * this.getY();
            float yt = (float)transform.get(1, 0) * this.getX() + (float)transform.get(1, 1) * this.getY();
            Feature f = this.clone();
            f.x = xt;
            f.y = yt;
            return f;
        }
        throw new IllegalArgumentException("Transform matrix has unexpected size");
    }

    public Point2d minus(Point2d a) {
        Feature p = this.clone();
        p.setX(this.getX() - a.getX());
        p.setY(this.getY() - a.getY());
        return p;
    }

    public void readASCII(Scanner in) throws IOException {
        this.x = in.nextFloat();
        this.y = in.nextFloat();
        this.val = in.nextInt();
    }

    public String asciiHeader() {
        return this.getClass().getName();
    }

    public void readBinary(DataInput in) throws IOException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.val = in.readInt();
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%f %f %d", Float.valueOf(this.x), Float.valueOf(this.y), this.val);
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeInt(this.val);
    }

    public void translate(Point2d v) {
        this.translate(v.getX(), v.getY());
    }

    public Feature copy() {
        return this.clone();
    }
}

