/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation;

import java.util.List;
import java.util.Set;
import org.openimaj.data.dataset.cache.GroupedListCache;
import org.openimaj.data.dataset.cache.InMemoryGroupedListCache;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.BatchAnnotator;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.ScoredAnnotation;

public class InstanceCachingIncrementalBatchAnnotator<OBJECT, ANNOTATION>
extends IncrementalAnnotator<OBJECT, ANNOTATION> {
    BatchAnnotator<OBJECT, ANNOTATION> batchAnnotator;
    GroupedListCache<ANNOTATION, OBJECT> objectCache;
    boolean isInvalid = true;

    public InstanceCachingIncrementalBatchAnnotator(BatchAnnotator<OBJECT, ANNOTATION> batchAnnotator) {
        this.batchAnnotator = batchAnnotator;
        this.objectCache = new InMemoryGroupedListCache();
    }

    public InstanceCachingIncrementalBatchAnnotator(BatchAnnotator<OBJECT, ANNOTATION> batchAnnotator, GroupedListCache<ANNOTATION, OBJECT> cache) {
        this.batchAnnotator = batchAnnotator;
        this.objectCache = cache;
    }

    @Override
    public void train(Annotated<OBJECT, ANNOTATION> annotated) {
        this.objectCache.add(annotated.getAnnotations(), annotated.getObject());
        this.isInvalid = true;
    }

    @Override
    public void reset() {
        this.objectCache.reset();
        this.isInvalid = true;
    }

    @Override
    public Set<ANNOTATION> getAnnotations() {
        return this.objectCache.getDataset().getGroups();
    }

    @Override
    public List<ScoredAnnotation<ANNOTATION>> annotate(OBJECT object) {
        if (this.isInvalid) {
            this.batchAnnotator.train(this.objectCache.getDataset());
            this.isInvalid = false;
        }
        return this.batchAnnotator.annotate(object);
    }
}

