/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.utils;

import gnu.trove.list.array.TIntArrayList;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.ml.annotation.Annotated;

public class AnnotatedListHelper<OBJECT, ANNOTATION> {
    Map<ANNOTATION, TIntArrayList> index = new HashMap<ANNOTATION, TIntArrayList>();
    List<? extends Annotated<OBJECT, ANNOTATION>> data;

    public AnnotatedListHelper(List<? extends Annotated<OBJECT, ANNOTATION>> list) {
        this.data = list;
        for (int i = 0; i < list.size(); ++i) {
            Annotated<OBJECT, ANNOTATION> item = list.get(i);
            HashSet<ANNOTATION> annotations = new HashSet<ANNOTATION>(item.getAnnotations());
            for (Object annotation : annotations) {
                TIntArrayList indices = this.index.get(annotation);
                if (indices == null) {
                    indices = new TIntArrayList();
                    this.index.put(annotation, indices);
                }
                indices.add(i);
            }
        }
    }

    public List<Annotated<OBJECT, ANNOTATION>> get(final ANNOTATION annotation) {
        if (!this.index.containsKey(annotation)) {
            return null;
        }
        return new AbstractList<Annotated<OBJECT, ANNOTATION>>(){
            TIntArrayList indices;
            {
                this.indices = AnnotatedListHelper.this.index.get(annotation);
            }

            @Override
            public Annotated<OBJECT, ANNOTATION> get(int index) {
                return AnnotatedListHelper.this.data.get(this.indices.get(index));
            }

            @Override
            public int size() {
                return this.indices.size();
            }
        };
    }

    public Set<ANNOTATION> getAnnotations() {
        return this.index.keySet();
    }

    public <FEATURE> List<FEATURE> extractFeatures(final ANNOTATION annotation, final FeatureExtractor<FEATURE, OBJECT> extractor) {
        if (!this.index.containsKey(annotation)) {
            return null;
        }
        return new AbstractList<FEATURE>(){
            TIntArrayList indices;
            {
                this.indices = AnnotatedListHelper.this.index.get(annotation);
            }

            @Override
            public FEATURE get(int index) {
                return extractor.extractFeature(AnnotatedListHelper.this.data.get(this.indices.get(index)).getObject());
            }

            @Override
            public int size() {
                return this.indices.size();
            }
        };
    }

    public <FEATURE> List<FEATURE> extractFeaturesExclude(ANNOTATION annotation, final FeatureExtractor<FEATURE, OBJECT> extractor) {
        TIntArrayList excludedIndices = this.index.get(annotation);
        final TIntArrayList selectedIndices = new TIntArrayList(this.data.size() - excludedIndices.size());
        for (int i = 0; i < this.data.size(); ++i) {
            if (excludedIndices.binarySearch(i) >= 0) continue;
            selectedIndices.add(i);
        }
        return new AbstractList<FEATURE>(){

            @Override
            public FEATURE get(int index) {
                return extractor.extractFeature(AnnotatedListHelper.this.data.get(selectedIndices.get(index)).getObject());
            }

            @Override
            public int size() {
                return selectedIndices.size();
            }
        };
    }
}

