/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.learner.matlib.regul;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import org.apache.log4j.Logger;
import org.openimaj.math.matrix.MatlibMatrixUtils;
import org.openimaj.ml.linear.learner.matlib.regul.Regulariser;

public class L1L2Regulariser
implements Regulariser {
    private static final Logger logger = Logger.getLogger(L1L2Regulariser.class);

    @Override
    public Matrix prox(Matrix W, double lambda) {
        int nrows = W.rowCount();
        Matrix ret = W.newInstance();
        for (int r = 0; r < nrows; ++r) {
            Vector row = W.row(r);
            double rownorm = MatlibMatrixUtils.norm2((Vector)row);
            if (!(rownorm > lambda)) continue;
            double scal = (rownorm - lambda) / rownorm;
            MatlibMatrixUtils.setSubMatrixRow((Matrix)ret, (int)r, (int)0, (Vector)row.times(scal));
        }
        return ret;
    }
}

