/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries;

import org.openimaj.ml.timeseries.TimeSeriesSetException;
import org.openimaj.ml.timeseries.converter.TimeSeriesConverter;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.util.pair.IndependentPair;

public abstract class TimeSeries<DATA, SINGLE_TYPE, RETURNTYPE extends TimeSeries<DATA, SINGLE_TYPE, RETURNTYPE>>
implements Iterable<IndependentPair<Long, SINGLE_TYPE>> {
    public RETURNTYPE get(long time) {
        return this.get(time, 0, 0);
    }

    public abstract RETURNTYPE get(long var1, int var3, int var4);

    public abstract RETURNTYPE get(long var1, int var3, int var4, RETURNTYPE var5);

    public abstract RETURNTYPE get(long var1, long var3, long var5);

    public abstract RETURNTYPE get(long var1, long var3);

    public abstract void set(long[] var1, DATA var2) throws TimeSeriesSetException;

    public abstract long[] getTimes();

    public abstract DATA getData();

    public abstract RETURNTYPE newInstance();

    public abstract int size();

    public abstract void internalAssign(RETURNTYPE var1);

    public void internalAssign(long[] times, DATA data) {
        try {
            this.set(times, data);
        }
        catch (TimeSeriesSetException timeSeriesSetException) {
            // empty catch block
        }
    }

    public RETURNTYPE copy() {
        TimeSeries t = this.newInstance();
        t.internalAssign((TimeSeries)this);
        return (RETURNTYPE)t;
    }

    public RETURNTYPE process(TimeSeriesProcessor<DATA, SINGLE_TYPE, RETURNTYPE> tsp) {
        RETURNTYPE copy = this.copy();
        tsp.process(copy);
        return copy;
    }

    private RETURNTYPE self() {
        return (RETURNTYPE)this;
    }

    public RETURNTYPE processInplace(TimeSeriesProcessor<DATA, SINGLE_TYPE, RETURNTYPE> tsp) {
        tsp.process(this.self());
        return this.self();
    }

    public <OUTDATA, OUTSING, OUTRET extends TimeSeries<OUTDATA, OUTSING, OUTRET>> OUTRET convert(TimeSeriesConverter<DATA, SINGLE_TYPE, RETURNTYPE, OUTDATA, OUTSING, OUTRET> converter) {
        return converter.convert(this.self());
    }

    public <OUTDATA, OUTSING, OUTRET extends TimeSeries<OUTDATA, OUTSING, OUTRET>> OUTRET convert(TimeSeriesConverter<DATA, SINGLE_TYPE, RETURNTYPE, OUTDATA, OUTSING, OUTRET> converter, TimeSeriesProcessor<OUTDATA, OUTSING, OUTRET> tsp) {
        return converter.convert(this.self(), tsp);
    }

    public abstract String toString();
}

