/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor;

import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class GaussianTimeSeriesProcessor
implements TimeSeriesProcessor<double[], Double, DoubleTimeSeries> {
    private double[] kernel;
    public static final double DEFAULT_GAUSS_TRUNCATE = 4.0;

    public GaussianTimeSeriesProcessor(double sigma) {
        this.kernel = GaussianTimeSeriesProcessor.makeKernel(sigma, 4.0);
    }

    public static double[] makeKernel(double sigma, double truncate) {
        int i;
        if (sigma == 0.0) {
            return new double[]{1.0};
        }
        int ksize = (int)(2.0 * truncate * sigma + 1.0);
        if (ksize % 2 == 0) {
            ++ksize;
        }
        double[] kernel = new double[ksize];
        float sum = 0.0f;
        for (i = 0; i < ksize; ++i) {
            float x = i - ksize / 2;
            kernel[i] = (float)Math.exp((double)(-x * x) / (2.0 * sigma * sigma));
            sum = (float)((double)sum + kernel[i]);
        }
        i = 0;
        while (i < ksize) {
            int n = i++;
            kernel[n] = kernel[n] / (double)sum;
        }
        return kernel;
    }

    public static void convolveHorizontal(double[] data, double[] kernel) {
        int i;
        int halfsize = kernel.length / 2;
        double[] buffer = new double[data.length + kernel.length];
        for (i = 0; i < halfsize; ++i) {
            buffer[i] = data[0];
        }
        for (i = 0; i < data.length; ++i) {
            buffer[halfsize + i] = data[i];
        }
        for (i = 0; i < halfsize; ++i) {
            buffer[halfsize + data.length + i] = data[data.length - 1];
        }
        int l = buffer.length - kernel.length;
        for (int i2 = 0; i2 < l; ++i2) {
            float sum = 0.0f;
            int j = 0;
            int jj = kernel.length - 1;
            while (j < kernel.length) {
                sum = (float)((double)sum + buffer[i2 + j] * kernel[jj]);
                ++j;
                --jj;
            }
            buffer[i2] = sum;
        }
        for (int c = 0; c < data.length; ++c) {
            data[c] = buffer[c];
        }
    }

    @Override
    public void process(DoubleTimeSeries series) {
        GaussianTimeSeriesProcessor.convolveHorizontal(series.getData(), this.kernel);
    }
}

