/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jon/Work/openimaj/tags/openimaj-1.3.1/machine-learning/nearest-neighbour/src/main/jtemp/org/openimaj/lsh/functions/#T#HashFunction.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.engine.MersenneTwister;

import org.openimaj.feature.IntFV;
import org.openimaj.feature.SparseIntFV;
import org.openimaj.util.array.SparseIntArray;

/**
 * Base {@link RandomisedHashFunction} for hashing int arrays.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 */
public abstract class IntHashFunction extends RandomisedHashFunction<int[]> {
	/**
	 * Default constructor
	 * 
	 * @param factory
	 *            factory to use
	 * @param rng
	 *            random generator
	 */
	IntHashFunction(MersenneTwister rng) {
		super(rng);
	}
	
	/**
	 * Compute the hash code for the feature vector.
	 * 
	 * @param feature
	 *            the feature vector
	 * 
	 * @return the hash code
	 */
	public final int computeHashCode(IntFV feature) {
		return computeHashCode(feature.values);
	}
	
	/**
	 * Compute the hash code for the sparse array. This method 
	 * converts the sparse array to a dense one and computes the
	 * hash code from that. Subclasses should override this method
	 * for improved performance.
	 * 
	 * @param array
	 *            the sparse array
	 * 
	 * @return the hash code
	 */
	public int computeHashCode(SparseIntArray array) {
		return computeHashCode(array.toArray());
	}
	
	/**
	 * Compute the hash code for the sparse feature vector.
	 * 
	 * @param feature
	 *            the sparse feature
	 * 
	 * @return the hash code
	 */
	public final int computeHashCode(SparseIntFV feature) {
		return computeHashCode(feature.values);
	}
}
