/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jon/Work/openimaj/tags/openimaj-1.3.1/machine-learning/nearest-neighbour/src/main/jtemp/org/openimaj/lsh/functions/#T#HyperplaneCosineFactory.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.lsh.functions;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.util.array.SparseLongArray;
import org.openimaj.util.array.SparseLongArray.Entry;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;

/**
 * A hash function factory that produces hash functions that approximate cosine
 * distance using hyperplanes.
 * <p>
 * The hash function hashes the input vector into a binary value (i.e. 0 or 1). 
 * A random vector on the surface of a hypersphere is generated during construction.  
 * The hash code is computed by calculating the dot product of the random vector 
 * with the input vector and testing to see whether the value is greater than or 
 * equal to 0 (1 is output) or less than 0 (0 is output).  
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 */
 @Reference(
	type = ReferenceType.Inproceedings,
	author = { "Charikar, Moses S." },
	title = "Similarity estimation techniques from rounding algorithms",
	year = "2002",
	booktitle = "Proceedings of the thiry-fourth annual ACM symposium on Theory of computing",
	pages = { "380", "", "388" },
	url = "http://doi.acm.org/10.1145/509907.509965",
	publisher = "ACM",
	series = "STOC '02"
)
public class LongHyperplaneCosineFactory extends LongHashFunctionFactory {
	private class Function extends LongHashFunction {
		double[] r;

		Function(int ndims, MersenneTwister rng) {
			super(rng);

            final Normal normal = new Normal(0, 1, rng);

			r = new double[ndims];
			double sumSq = 0;
			
			for (int i=0; i<ndims; i++) {
				r[i] = normal.nextDouble();
				sumSq += (r[i] * r[i]);
			}
			
			double norm = 1.0 / Math.sqrt(sumSq);
			for (int i=0; i<ndims; i++) {
				r[i] *= norm;
			}
		}

		@Override
		public int computeHashCode(long[] point) {
			double dp = 0;
			
			for (int i=0; i<ndims; i++)
				dp += r[i] * point[i];
				
			return dp >= 0 ? 1 : 0;
		}

		@Override
		public int computeHashCode(SparseLongArray array) {
			double dp = 0;
			
			for (Entry e : array.entries())
				dp += r[e.index] * e.value;
				
			return dp >= 0 ? 1 : 0;
		}
	}

	/**
	 * Construct with the given arguments.
	 * 
	 * @param ndims
	 *            The number of dimensions
	 * @param rng
	 *            A random number generator
	 */
	public LongHyperplaneCosineFactory(int ndims, MersenneTwister rng) {
		super(ndims, rng);
	}

	@Override
	public Function create() {
		return new Function(ndims, rng);
	}

	@Override
	protected LongFVComparison fvDistanceFunction() {
		return LongFVComparison.CITY_BLOCK;
	}
}
