/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.LongFVComparator;
import org.openimaj.feature.LongFVComparison;
import org.openimaj.knn.LongNearestNeighbours;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.util.pair.IntDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class LongNearestNeighboursExact
extends LongNearestNeighbours {
    protected final long[][] pnts;
    protected final LongFVComparator distance;

    public LongNearestNeighboursExact(long[][] pnts) {
        this(pnts, null);
    }

    public LongNearestNeighboursExact(long[][] pnts, LongFVComparator distance) {
        this.pnts = pnts;
        this.distance = distance;
    }

    public void searchNN(long[][] qus, int[] indices, double[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus[n], (BoundedPriorityQueue<IntDoublePair>)queue, list);
            IntDoublePair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(long[][] qus, int K, int[][] indices, double[][] distances) {
        K = Math.min(K, this.pnts.length);
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus[n], (BoundedPriorityQueue<IntDoublePair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntDoublePair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<long[]> qus, int[] indices, double[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntDoublePair>)queue, list);
            IntDoublePair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<long[]> qus, int K, int[][] indices, double[][] distances) {
        K = Math.min(K, this.pnts.length);
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntDoublePair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntDoublePair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntDoublePair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntDoublePair> searchKNN(long[] query, int K) {
        K = Math.min(K, this.pnts.length);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntDoublePair());
        }
        return this.search(query, (BoundedPriorityQueue<IntDoublePair>)queue, list);
    }

    @Override
    public IntDoublePair searchNN(long[] query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntDoublePair> list = new ArrayList<IntDoublePair>(2);
        list.add(new IntDoublePair());
        list.add(new IntDoublePair());
        return this.search(query, (BoundedPriorityQueue<IntDoublePair>)queue, list).get(0);
    }

    private List<IntDoublePair> search(long[] query, BoundedPriorityQueue<IntDoublePair> queue, List<IntDoublePair> results) {
        IntDoublePair wp = null;
        for (IntDoublePair p : results) {
            p.second = 3.4028234663852886E38;
            p.first = -1;
            wp = (IntDoublePair)queue.offerItem((Object)p);
        }
        int i = 0;
        while (i < this.pnts.length) {
            wp.second = LongNearestNeighboursExact.distanceFunc(this.distance, query, this.pnts[i]);
            wp.first = i++;
            wp = (IntDoublePair)queue.offerItem((Object)wp);
        }
        return queue.toOrderedListDestructive();
    }

    @Override
    public int numDimensions() {
        return this.pnts[0].length;
    }

    @Override
    public int size() {
        return this.pnts.length;
    }

    public long[][] getPoints() {
        return this.pnts;
    }

    public double computeDistance(long[] a, long[] b) {
        if (this.distance == null) {
            return LongFVComparison.SUM_SQUARE.compare(a, b);
        }
        return this.distance.compare(a, b);
    }

    public static final class Factory
    implements NearestNeighboursFactory<LongNearestNeighboursExact, long[]> {
        private final LongFVComparator distance;

        public Factory() {
            this.distance = null;
        }

        public Factory(LongFVComparator distance) {
            this.distance = distance;
        }

        public LongNearestNeighboursExact create(long[][] data) {
            return new LongNearestNeighboursExact(data, this.distance);
        }
    }
}

