/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.feature.IntFVComparison;
import org.openimaj.lsh.functions.IntPStableFactory;

public class IntCauchyFactory
extends IntPStableFactory {
    public IntCauchyFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng, w);
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected IntFVComparison fvDistanceFunction() {
        return IntFVComparison.EUCLIDEAN;
    }

    private class Function
    extends IntPStableFactory.PStableFunction {
        Function(int ndims, MersenneTwister rng) {
            super(IntCauchyFactory.this, rng);
            Uniform uniform = new Uniform(0.0, IntCauchyFactory.this.w, (RandomEngine)rng);
            this.b = (float)uniform.nextDouble();
            this.r = new double[ndims];
            for (int i = 0; i < ndims; ++i) {
                this.r[i] = this.cauchy();
            }
        }

        private final double cauchy() {
            return Math.tan(Math.PI * (IntCauchyFactory.this.rng.nextDouble() - 0.5));
        }
    }
}

