/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.FloatFVComparator;
import org.openimaj.feature.FloatFVComparison;
import org.openimaj.knn.FloatNearestNeighbours;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class FloatNearestNeighboursExact
extends FloatNearestNeighbours {
    protected final float[][] pnts;
    protected final FloatFVComparator distance;

    public FloatNearestNeighboursExact(float[][] pnts) {
        this(pnts, null);
    }

    public FloatNearestNeighboursExact(float[][] pnts, FloatFVComparator distance) {
        this.pnts = pnts;
        this.distance = distance;
    }

    public void searchNN(float[][] qus, int[] indices, float[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(float[][] qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.pnts.length);
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<float[]> qus, int[] indices, float[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<float[]> qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.pnts.length);
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntFloatPair> searchKNN(float[] query, int K) {
        K = Math.min(K, this.pnts.length);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list);
    }

    @Override
    public IntFloatPair searchNN(float[] query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list).get(0);
    }

    private List<IntFloatPair> search(float[] query, BoundedPriorityQueue<IntFloatPair> queue, List<IntFloatPair> results) {
        IntFloatPair wp = null;
        for (IntFloatPair p : results) {
            p.second = Float.MAX_VALUE;
            p.first = -1;
            wp = (IntFloatPair)queue.offerItem((Object)p);
        }
        int i = 0;
        while (i < this.pnts.length) {
            wp.second = FloatNearestNeighboursExact.distanceFunc(this.distance, query, this.pnts[i]);
            wp.first = i++;
            wp = (IntFloatPair)queue.offerItem((Object)wp);
        }
        return queue.toOrderedListDestructive();
    }

    @Override
    public int numDimensions() {
        return this.pnts[0].length;
    }

    @Override
    public int size() {
        return this.pnts.length;
    }

    public float[][] getPoints() {
        return this.pnts;
    }

    public float computeDistance(float[] a, float[] b) {
        if (this.distance == null) {
            return (float)FloatFVComparison.SUM_SQUARE.compare(a, b);
        }
        return (float)this.distance.compare(a, b);
    }

    public FloatFVComparator distanceComparator() {
        return this.distance;
    }

    public static final class Factory
    implements NearestNeighboursFactory<FloatNearestNeighboursExact, float[]> {
        private final FloatFVComparator distance;

        public Factory() {
            this.distance = null;
        }

        public Factory(FloatFVComparator distance) {
            this.distance = distance;
        }

        public FloatNearestNeighboursExact create(float[][] data) {
            return new FloatNearestNeighboursExact(data, this.distance);
        }
    }
}

