/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn.pq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.pq.ByteProductQuantiser;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

@Reference(type=ReferenceType.Article, author={"Jegou, Herve", "Douze, Matthijs", "Schmid, Cordelia"}, title="Product Quantization for Nearest Neighbor Search", year="2011", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"117", "", "128"}, url="http://dx.doi.org/10.1109/TPAMI.2010.57", month="January", number="1", publisher="IEEE Computer Society", volume="33", customData={"issn", "0162-8828", "numpages", "12", "doi", "10.1109/TPAMI.2010.57", "acmid", "1916695", "address", "Washington, DC, USA", "keywords", "High-dimensional indexing, High-dimensional indexing, image indexing, very large databases, approximate search., approximate search., image indexing, very large databases"})
public class ByteADCNearestNeighbours
extends ByteNearestNeighbours {
    protected final ByteProductQuantiser pq;
    protected final int ndims;
    protected final byte[][] data;

    public ByteADCNearestNeighbours(ByteProductQuantiser pq, byte[][] dataPoints) {
        this.pq = pq;
        this.ndims = dataPoints[0].length;
        this.data = new byte[dataPoints.length][];
        for (int i = 0; i < dataPoints.length; ++i) {
            this.data[i] = pq.quantise(dataPoints[i]);
        }
    }

    public ByteADCNearestNeighbours(ByteProductQuantiser pq, byte[][] pqData, int ndims) {
        this.ndims = ndims;
        this.pq = pq;
        this.data = pqData;
    }

    public void searchNN(byte[][] qus, int[] indices, float[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(byte[][] qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.data.length);
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<byte[]> qus, int[] indices, float[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<byte[]> qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.data.length);
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntFloatPair> searchKNN(byte[] query, int K) {
        K = Math.min(K, this.data.length);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list);
    }

    @Override
    public IntFloatPair searchNN(byte[] query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list).get(0);
    }

    private List<IntFloatPair> search(byte[] query, BoundedPriorityQueue<IntFloatPair> queue, List<IntFloatPair> results) {
        IntFloatPair wp = null;
        for (IntFloatPair p : results) {
            p.second = Float.MAX_VALUE;
            p.first = -1;
            wp = (IntFloatPair)queue.offerItem((Object)p);
        }
        this.computeDistances(query, queue, wp);
        return queue.toOrderedListDestructive();
    }

    protected void computeDistances(byte[] fullQuery, BoundedPriorityQueue<IntFloatPair> queue, IntFloatPair wp) {
        float[][] distances = new float[this.pq.assigners.length][];
        int from = 0;
        for (int j = 0; j < this.pq.assigners.length; ++j) {
            ByteNearestNeighbours nn = this.pq.assigners[j];
            int to = nn.numDimensions();
            int K = nn.size();
            byte[][] qus = new byte[][]{Arrays.copyOfRange(fullQuery, from, from + to)};
            int[][] idx = new int[1][K];
            float[][] dst = new float[1][K];
            nn.searchKNN((DATA[])qus, K, idx, (DISTANCES[])dst);
            distances[j] = new float[K];
            for (int k = 0; k < K; ++k) {
                distances[j][idx[0][k]] = dst[0][k];
            }
            from += to;
        }
        for (int i = 0; i < this.data.length; ++i) {
            wp.first = i;
            wp.second = 0.0f;
            for (int j = 0; j < this.pq.assigners.length; ++j) {
                int centroid = this.data[i][j] + 128;
                wp.second += distances[j][centroid];
            }
            wp = (IntFloatPair)queue.offerItem((Object)wp);
        }
    }

    @Override
    public int numDimensions() {
        return this.ndims;
    }

    @Override
    public int size() {
        return this.data.length;
    }
}

