/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.engine.MersenneTwister;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.lsh.functions.DoubleHashFunction;
import org.openimaj.lsh.functions.DoubleHashFunctionFactory;
import org.openimaj.util.array.SparseDoubleArray;

@Reference(type=ReferenceType.Inproceedings, author={"Datar, Mayur", "Immorlica, Nicole", "Indyk, Piotr", "Mirrokni, Vahab S."}, title="Locality-sensitive hashing scheme based on p-stable distributions", year="2004", booktitle="Proceedings of the twentieth annual symposium on Computational geometry", pages={"253", "", "262"}, url="http://doi.acm.org/10.1145/997817.997857", publisher="ACM", series="SCG '04")
public abstract class DoublePStableFactory
extends DoubleHashFunctionFactory {
    double w;

    public DoublePStableFactory(int ndims, MersenneTwister rng, double w) {
        super(ndims, rng);
        this.w = w;
    }

    protected abstract class PStableFunction
    extends DoubleHashFunction {
        protected double[] r;
        protected double b;

        PStableFunction(MersenneTwister rng) {
            super(rng);
        }

        public final int computeHashCode(double[] point) {
            double val = 0.0;
            for (int i = 0; i < point.length; ++i) {
                val += point[i] * this.r[i];
            }
            val = (val + this.b) / DoublePStableFactory.this.w;
            return (int)Math.floor(val);
        }

        @Override
        public int computeHashCode(SparseDoubleArray array) {
            double val = 0.0;
            for (SparseDoubleArray.Entry e : array.entries()) {
                val += e.value * this.r[e.index];
            }
            val = (val + this.b) / DoublePStableFactory.this.w;
            return (int)Math.floor(val);
        }
    }
}

