/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.sketch;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.openimaj.util.hash.HashFunction;
import org.openimaj.util.hash.HashFunctionFactory;
import org.openimaj.util.sketch.Sketcher;

public class BitSetLSHSketcher<OBJECT>
implements Sketcher<OBJECT, BitSet> {
    List<HashFunction<OBJECT>> hashFunctions;

    public BitSetLSHSketcher(List<HashFunction<OBJECT>> functions) {
        this.hashFunctions = functions;
    }

    @SafeVarargs
    public BitSetLSHSketcher(HashFunction<OBJECT> first, HashFunction<OBJECT> ... remainder) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        this.hashFunctions.add(first);
        for (HashFunction<OBJECT> r : remainder) {
            this.hashFunctions.add(r);
        }
    }

    public BitSetLSHSketcher(HashFunctionFactory<OBJECT> factory, int nFuncs) {
        this.hashFunctions = new ArrayList<HashFunction<OBJECT>>();
        for (int i = 0; i < nFuncs; ++i) {
            this.hashFunctions.add(factory.create());
        }
    }

    public BitSet createSketch(OBJECT input) {
        int nbits = this.bitLength();
        BitSet sketch = new BitSet(nbits);
        for (int k = 0; k < nbits; ++k) {
            int hash = this.hashFunctions.get(k).computeHashCode(input);
            sketch.set(k, (hash & 1) == 1);
        }
        return sketch;
    }

    public int bitLength() {
        return this.hashFunctions.size();
    }
}

