/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.knn.IncrementalNearestNeighbours;
import org.openimaj.knn.ObjectNearestNeighbours;
import org.openimaj.util.comparator.DistanceComparator;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class ObjectNearestNeighboursExact<T>
extends ObjectNearestNeighbours<T>
implements IncrementalNearestNeighbours<T, float[], IntFloatPair> {
    protected final List<T> pnts;

    public ObjectNearestNeighboursExact(List<T> pnts, DistanceComparator<? super T> distance) {
        super(distance);
        this.pnts = pnts;
    }

    public ObjectNearestNeighboursExact(DistanceComparator<T> distance) {
        super(distance);
        this.pnts = new ArrayList<T>();
    }

    @Override
    public void searchNN(T[] qus, int[] indices, float[] distances) {
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(T[] qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.pnts.size());
        int N = qus.length;
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus[n], (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public void searchNN(List<T> qus, int[] indices, float[] distances) {
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            IntFloatPair p = result.get(0);
            indices[n] = p.first;
            distances[n] = p.second;
        }
    }

    public void searchKNN(List<T> qus, int K, int[][] indices, float[][] distances) {
        K = Math.min(K, this.pnts.size());
        int N = qus.size();
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        for (int n = 0; n < N; ++n) {
            List<IntFloatPair> result = this.search(qus.get(n), (BoundedPriorityQueue<IntFloatPair>)queue, list);
            for (int k = 0; k < K; ++k) {
                IntFloatPair p = result.get(k);
                indices[n][k] = p.first;
                distances[n][k] = p.second;
            }
        }
    }

    @Override
    public List<IntFloatPair> searchKNN(T query, int K) {
        K = Math.min(K, this.pnts.size());
        BoundedPriorityQueue queue = new BoundedPriorityQueue(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
        for (int i = 0; i < K + 1; ++i) {
            list.add(new IntFloatPair());
        }
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list);
    }

    @Override
    public IntFloatPair searchNN(T query) {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ArrayList<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
        list.add(new IntFloatPair());
        list.add(new IntFloatPair());
        return this.search(query, (BoundedPriorityQueue<IntFloatPair>)queue, list).get(0);
    }

    private List<IntFloatPair> search(T query, BoundedPriorityQueue<IntFloatPair> queue, List<IntFloatPair> results) {
        IntFloatPair wp = null;
        for (IntFloatPair p : results) {
            p.second = Float.MAX_VALUE;
            p.first = -1;
            wp = (IntFloatPair)queue.offerItem((Object)p);
        }
        int size = this.pnts.size();
        int i = 0;
        while (i < size) {
            wp.second = ObjectNearestNeighbours.distanceFunc(this.distance, query, this.pnts.get(i));
            wp.first = i++;
            wp = (IntFloatPair)queue.offerItem((Object)wp);
        }
        return queue.toOrderedListDestructive();
    }

    @Override
    public int size() {
        return this.pnts.size();
    }

    @Override
    public int[] addAll(List<T> d) {
        int[] indexes = new int[d.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.add(d.get(i));
        }
        return indexes;
    }

    @Override
    public int add(T o) {
        int ret = this.pnts.size();
        this.pnts.add(o);
        return ret;
    }
}

