/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.lsh.functions;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.ShortFVComparison;
import org.openimaj.lsh.functions.ShortHashFunction;
import org.openimaj.lsh.functions.ShortHashFunctionFactory;
import org.openimaj.util.array.SparseShortArray;

@Reference(type=ReferenceType.Inproceedings, author={"Charikar, Moses S."}, title="Similarity estimation techniques from rounding algorithms", year="2002", booktitle="Proceedings of the thiry-fourth annual ACM symposium on Theory of computing", pages={"380", "", "388"}, url="http://doi.acm.org/10.1145/509907.509965", publisher="ACM", series="STOC '02")
public class ShortHyperplaneCosineFactory
extends ShortHashFunctionFactory {
    public ShortHyperplaneCosineFactory(int ndims, MersenneTwister rng) {
        super(ndims, rng);
    }

    public Function create() {
        return new Function(this.ndims, this.rng);
    }

    @Override
    protected ShortFVComparison fvDistanceFunction() {
        return ShortFVComparison.CITY_BLOCK;
    }

    private class Function
    extends ShortHashFunction {
        double[] r;

        Function(int ndims, MersenneTwister rng) {
            super(rng);
            Normal normal = new Normal(0.0, 1.0, (RandomEngine)rng);
            this.r = new double[ndims];
            double sumSq = 0.0;
            for (int i = 0; i < ndims; ++i) {
                this.r[i] = normal.nextDouble();
                sumSq += this.r[i] * this.r[i];
            }
            double norm = 1.0 / Math.sqrt(sumSq);
            int i = 0;
            while (i < ndims) {
                int n = i++;
                this.r[n] = this.r[n] * norm;
            }
        }

        public int computeHashCode(short[] point) {
            double dp = 0.0;
            for (int i = 0; i < ShortHyperplaneCosineFactory.this.ndims; ++i) {
                dp += this.r[i] * (double)point[i];
            }
            return dp >= 0.0 ? 1 : 0;
        }

        @Override
        public int computeHashCode(SparseShortArray array) {
            double dp = 0.0;
            for (SparseShortArray.Entry e : array.entries()) {
                dp += this.r[e.index] * (double)e.value;
            }
            return dp >= 0.0 ? 1 : 0;
        }
    }
}

