/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.haar.Stage;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public class StageTreeClassifier {
    int width;
    int height;
    String name;
    boolean hasTiltedFeatures;
    Stage root;
    float cachedScale;
    float cachedInvArea;
    int cachedW;
    int cachedH;

    public StageTreeClassifier(int width, int height, String name, boolean hasTiltedFeatures, Stage root) {
        this.width = width;
        this.height = height;
        this.name = name;
        this.hasTiltedFeatures = hasTiltedFeatures;
        this.root = root;
    }

    float computeWindowVarianceNorm(SummedSqTiltAreaTable sat, int x, int y) {
        float sum;
        float mean;
        float sqSum;
        float wvNorm;
        wvNorm = (float)((wvNorm = (sqSum = sat.sqSum.pixels[(y += Math.round(this.cachedScale)) + this.cachedH][(x += Math.round(this.cachedScale)) + this.cachedW] + sat.sqSum.pixels[y][x] - sat.sqSum.pixels[y + this.cachedH][x] - sat.sqSum.pixels[y][x + this.cachedW]) * this.cachedInvArea - (mean = (sum = sat.sum.pixels[y + this.cachedH][x + this.cachedW] + sat.sum.pixels[y][x] - sat.sum.pixels[y + this.cachedH][x] - sat.sum.pixels[y][x + this.cachedW]) * this.cachedInvArea) * mean) >= 0.0f ? Math.sqrt(wvNorm) : 1.0);
        return wvNorm;
    }

    public void setScale(float scale) {
        this.cachedScale = scale;
        this.cachedW = Math.round(scale * (float)(this.width - 2));
        this.cachedH = Math.round(scale * (float)(this.height - 2));
        this.cachedInvArea = 1.0f / (float)(this.cachedW * this.cachedH);
        this.updateCaches(this.root);
    }

    private void updateCaches(Stage s) {
        s.updateCaches(this);
        if (s.successStage != null) {
            this.updateCaches(s.successStage);
        }
        if (s.failureStage != null) {
            this.updateCaches(s.failureStage);
        }
    }

    public int classify(SummedSqTiltAreaTable sat, int x, int y) {
        float wvNorm = this.computeWindowVarianceNorm(sat, x, y);
        int matches = 0;
        Stage stage = this.root;
        while (true) {
            if (stage.pass(sat, wvNorm, x, y)) {
                ++matches;
                stage = stage.successStage;
                if (stage != null) continue;
                return matches;
            }
            stage = stage.failureStage;
            if (stage == null) break;
        }
        return -matches;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTiltedFeatures() {
        return this.hasTiltedFeatures;
    }
}

