/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.xuggle;

import com.xuggle.ferry.JNIReference;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.URLProtocolManager;
import com.xuggle.xuggler.video.AConverter;
import com.xuggle.xuggler.video.BgrConverter;
import com.xuggle.xuggler.video.ConverterFactory;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.video.Video;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;
import org.openimaj.video.timecode.VideoTimecode;
import org.openimaj.video.xuggle.JarURLProtocolHandlerFactory;

public class XuggleVideo
extends Video<MBFImage> {
    private static final Logger logger = Logger.getLogger(XuggleVideo.class);
    private IMediaReader reader = null;
    private boolean currentFrameUpdated = false;
    private MBFImage currentMBFImage;
    private boolean currentFrameIsKeyFrame = false;
    private int streamIndex = -1;
    private int width = -1;
    private int height = -1;
    private long totalFrames = -1L;
    private final String url;
    private final boolean loop;
    private long timestamp;
    private long timestampOffset = 0L;
    private double fps;
    private MBFImage nextFrame = null;
    public long nextFrameTimestamp = 0L;
    public boolean nextFrameIsKeyFrame = false;

    public XuggleVideo(File videoFile) {
        this(videoFile.toURI().toString());
    }

    public XuggleVideo(File videoFile, boolean loop) {
        this(videoFile.toURI().toString(), loop);
    }

    public XuggleVideo(String url) {
        this(url, false);
    }

    public XuggleVideo(URL url) {
        this(url.toString(), false);
    }

    public XuggleVideo(URL url, boolean loop) {
        this(url.toString(), loop);
    }

    public XuggleVideo(String url, boolean loop) {
        this.url = url;
        this.loop = loop;
        this.create(url);
    }

    public XuggleVideo(InputStream stream) {
        this.url = null;
        this.loop = false;
        this.create(stream);
    }

    public XuggleVideo(DataInput input) {
        this.url = null;
        this.loop = false;
        this.create(input);
    }

    public long countFrames() {
        return this.totalFrames;
    }

    public MBFImage getNextFrame() {
        if (this.nextFrame != null) {
            this.currentMBFImage = this.nextFrame;
            this.timestamp = this.nextFrameTimestamp;
            this.currentFrameIsKeyFrame = this.nextFrameIsKeyFrame;
            this.nextFrame = null;
        } else {
            this.currentMBFImage = this.readFrame(false);
        }
        if (this.currentMBFImage != null) {
            ++this.currentFrame;
        }
        return this.currentMBFImage;
    }

    private synchronized MBFImage readFrame(boolean preserveCurrent) {
        if (this.reader == null) {
            return null;
        }
        long currentTimestamp = this.timestamp;
        boolean currentKeyFrameFlag = this.currentFrameIsKeyFrame;
        if (preserveCurrent && this.nextFrame == null && this.currentMBFImage != null) {
            MBFImage tmp = (MBFImage)this.currentMBFImage.clone();
            this.nextFrame = this.currentMBFImage;
            this.currentMBFImage = tmp;
        }
        IError e = null;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            while ((e = this.reader.readPacket()) == null && !this.currentFrameUpdated) {
            }
            if (e == null || e.getType() != IError.Type.ERROR_EOF || !this.loop) continue;
            this.timestampOffset += this.timestamp - this.timestampOffset;
            tryAgain = true;
            this.seekToBeginning();
        } while (tryAgain);
        if (!this.currentFrameUpdated || e != null) {
            return null;
        }
        this.currentFrameUpdated = false;
        if (preserveCurrent) {
            this.nextFrameIsKeyFrame = this.currentFrameIsKeyFrame;
            this.currentFrameIsKeyFrame = currentKeyFrameFlag;
            this.nextFrameTimestamp = this.timestamp;
            this.timestamp = currentTimestamp;
            if (this.nextFrame != null) {
                return this.nextFrame;
            }
            return this.currentMBFImage;
        }
        return this.currentMBFImage;
    }

    public VideoTimecode getCurrentTimecode() {
        return new HrsMinSecFrameTimecode((long)((double)this.timestamp / 1000.0 * this.fps), this.fps);
    }

    public MBFImage getCurrentFrame() {
        if (this.currentMBFImage == null) {
            this.currentMBFImage = this.getNextFrame();
        }
        return this.currentMBFImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean hasNextFrame() {
        if (this.nextFrame == null) {
            this.nextFrame = this.readFrame(true);
            return this.nextFrame != null;
        }
        return true;
    }

    public synchronized void reset() {
        if (this.reader == null) {
            if (this.url == null) {
                return;
            }
            this.create(this.url);
        } else {
            this.seekToBeginning();
        }
    }

    public synchronized void seekToBeginning() {
        if (this.url == null) {
            return;
        }
        this.reader.getContainer().seekKeyFrame(this.streamIndex, 0L, 0L, 0L, IContainer.SEEK_FLAG_BYTE);
        if (this.timestamp == 0L) {
            return;
        }
        this.reader.getContainer().seekKeyFrame(this.streamIndex, 0L, 0L, 0L, IContainer.SEEK_FLAG_FRAME);
        if (this.timestamp == 0L) {
            return;
        }
        this.reader.getContainer().seekKeyFrame(this.streamIndex, 0L, 0L, 0L, IContainer.SEEK_FLAG_BACKWARDS);
        if (this.timestamp == 0L) {
            return;
        }
        this.reader.getContainer().seekKeyFrame(this.streamIndex, 0L, 0L, 0L, IContainer.SEEK_FLAG_ANY);
        if (this.timestamp == 0L) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.create(this.url);
        this.getNextFrame();
    }

    private synchronized void create(String urlstring) {
        this.setupReader();
        IContainer container = null;
        int openResult = 0;
        try {
            container = IContainer.make();
            openResult = container.open(urlstring, IContainer.Type.READ, null, true, true);
            if (openResult < 0) {
                logger.info((Object)("URL " + urlstring + " could not be opened by ffmpeg. " + "Trying to open a stream to the URL instead."));
                DataInputStream is = new DataInputStream(new URL(urlstring).openStream());
                openResult = container.open((InputStream)is, null, true, true);
                if (openResult < 0) {
                    logger.error((Object)("Error opening container. Error " + openResult + " (" + IError.errorNumberToType((int)openResult).toString() + ")"));
                    return;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.setupReader(container);
    }

    private synchronized void create(InputStream stream) {
        this.setupReader();
        IContainer container = IContainer.make();
        int openResult = container.open(stream, null, true, true);
        if (openResult < 0) {
            logger.error((Object)("Error opening container. Error " + openResult + " (" + IError.errorNumberToType((int)openResult).toString() + ")"));
            return;
        }
        this.setupReader(container);
    }

    private synchronized void create(DataInput input) {
        this.setupReader();
        IContainer container = IContainer.make();
        int openResult = container.open(input, null, true, true);
        if (openResult < 0) {
            logger.error((Object)("Error opening container. Error " + openResult + " (" + IError.errorNumberToType((int)openResult).toString() + ")"));
            return;
        }
        this.setupReader(container);
    }

    private void setupReader() {
        this.currentFrame = 0;
        if (this.reader != null && this.reader.isOpen()) {
            this.reader.close();
            this.reader = null;
        }
    }

    private void setupReader(IContainer container) {
        this.reader = ToolFactory.makeReader((IContainer)container);
        this.reader.setBufferedImageTypeToGenerate(5);
        this.reader.addListener((IMediaListener)new FrameGetter());
        IStream s = null;
        for (int i = 0; i < container.getNumStreams(); ++i) {
            s = container.getStream((long)i);
            if (s == null || s.getStreamCoder().getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            this.streamIndex = i;
            break;
        }
        this.totalFrames = container.getDuration() == Global.NO_PTS ? -1L : (long)((double)s.getDuration() * s.getTimeBase().getDouble() * s.getFrameRate().getDouble());
        if (s != null) {
            this.fps = s.getFrameRate().getDouble();
        }
        if (s != null) {
            int w = s.getStreamCoder().getWidth();
            int h = s.getStreamCoder().getHeight();
            this.width = w;
            this.height = h;
        }
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public double getFPS() {
        return this.fps;
    }

    public synchronized int getCurrentFrameIndex() {
        return (int)((double)this.timestamp / 1000.0 * this.fps);
    }

    public void setCurrentFrameIndex(long newFrame) {
        this.seekPrecise((double)newFrame / this.fps);
    }

    public void seekPrecise(double timestamp) {
        this.seek(timestamp);
        timestamp *= 1000.0;
        double timePerFrame = 1000.0 / this.fps;
        while ((double)this.timestamp <= timestamp - timePerFrame && this.getNextFrame() != null) {
        }
    }

    public synchronized void seek(double timestamp) {
        if (this.reader == null) {
            if (this.url == null) {
                return;
            }
            this.create(this.url);
        }
        double timebase = this.reader.getContainer().getStream((long)this.streamIndex).getTimeBase().getDouble();
        long position = (long)(timestamp / timebase);
        long min = Math.max(0L, position - 100L);
        long max = position;
        int ret = this.reader.getContainer().seekKeyFrame(this.streamIndex, min, position, max, IContainer.SEEK_FLAG_ANY);
        if (ret >= 0) {
            this.getNextFrame();
        } else {
            logger.error((Object)("Seek returned an error value: " + ret + ": " + IError.errorNumberToType((int)ret)));
        }
    }

    public synchronized long getDuration() {
        long duration = this.reader.getContainer().getStream((long)this.streamIndex).getDuration();
        double timebase = this.reader.getContainer().getStream((long)this.streamIndex).getTimeBase().getDouble();
        return (long)((double)duration * timebase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.reader != null) {
            IMediaReader iMediaReader = this.reader;
            synchronized (iMediaReader) {
                if (this.reader.isOpen()) {
                    this.reader.close();
                    this.reader = null;
                }
            }
        }
    }

    static {
        URLProtocolManager.getManager().registerFactory("jar", (IURLProtocolHandlerFactory)new JarURLProtocolHandlerFactory());
        ConverterFactory.registerConverter((ConverterFactory.Type)new ConverterFactory.Type("XUGGLER-BGR-24", MBFImageConverter.class, IPixelFormat.Type.BGR24, 5));
    }

    protected static final class MBFImageConverter
    extends BgrConverter {
        private final MBFImageWrapper bimg = new MBFImageWrapper(null);
        private final byte[] buffer;

        public MBFImageConverter(IPixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
            super(pictureType, pictureWidth, pictureHeight, imageWidth, imageHeight);
            this.bimg.img = new MBFImage(imageWidth, imageHeight, ColourSpace.RGB);
            this.buffer = new byte[imageWidth * imageHeight * 3];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage toImage(IVideoPicture picture) {
            this.validatePicture(picture);
            IVideoPicture resamplePicture = null;
            AtomicReference<Object> ref = new AtomicReference<Object>(null);
            try {
                if (this.willResample()) {
                    picture = resamplePicture = AConverter.resample((IVideoPicture)picture, (IVideoResampler)this.mToImageResampler);
                }
                int w = picture.getWidth();
                int h = picture.getHeight();
                float[][] r = ((FImage)this.bimg.img.bands.get((int)0)).pixels;
                float[][] g = ((FImage)this.bimg.img.bands.get((int)1)).pixels;
                float[][] b = ((FImage)this.bimg.img.bands.get((int)2)).pixels;
                picture.getDataCached().get(0, this.buffer, 0, this.buffer.length);
                int i = 0;
                for (int y = 0; y < h; ++y) {
                    int x = 0;
                    while (x < w) {
                        b[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[this.buffer[i] & 0xFF];
                        g[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[this.buffer[i + 1] & 0xFF];
                        r[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[this.buffer[i + 2] & 0xFF];
                        ++x;
                        i += 3;
                    }
                }
                MBFImageWrapper mBFImageWrapper = this.bimg;
                return mBFImageWrapper;
            }
            finally {
                if (resamplePicture != null) {
                    resamplePicture.delete();
                }
                if (ref.get() != null) {
                    ((JNIReference)ref.get()).delete();
                }
            }
        }
    }

    protected static final class MBFImageWrapper
    extends BufferedImage {
        MBFImage img;

        public MBFImageWrapper(MBFImage img) {
            super(1, 1, 1);
            this.img = img;
        }
    }

    protected class FrameGetter
    extends MediaListenerAdapter {
        protected FrameGetter() {
        }

        public void onVideoPicture(IVideoPictureEvent event) {
            if (event.getStreamIndex() == XuggleVideo.this.streamIndex) {
                XuggleVideo.this.currentMBFImage = ((MBFImageWrapper)event.getImage()).img;
                XuggleVideo.this.currentFrameIsKeyFrame = event.getMediaData().isKeyFrame();
                XuggleVideo.this.timestamp = (long)((double)event.getPicture().getTimeStamp() * event.getPicture().getTimeBase().getDouble() * 1000.0) + XuggleVideo.this.timestampOffset;
                XuggleVideo.this.currentFrameUpdated = true;
            }
        }
    }
}

