/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.openml.apiconnector.algorithms.Hashing;
import org.openml.apiconnector.io.ApiException;
import org.openml.apiconnector.xml.ApiError;
import org.openml.apiconnector.xml.Authenticate;
import org.openml.apiconnector.xml.Data;
import org.openml.apiconnector.xml.DataFeature;
import org.openml.apiconnector.xml.DataQuality;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.Implementation;
import org.openml.apiconnector.xml.ImplementationDelete;
import org.openml.apiconnector.xml.ImplementationExists;
import org.openml.apiconnector.xml.ImplementationOwned;
import org.openml.apiconnector.xml.Job;
import org.openml.apiconnector.xml.Task;
import org.openml.apiconnector.xml.UploadDataSet;
import org.openml.apiconnector.xml.UploadImplementation;
import org.openml.apiconnector.xml.UploadRun;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class ApiConnector {
    public static String API_URL = "http://openml.liacs.nl/";
    public static final String API_PART = "rest_api/";
    private static XStream xstream = XstreamXmlMapping.getInstance();
    private static HttpClient httpclient;

    public static Authenticate openmlAuthenticate(String username, String password) throws Exception {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
        params.add(new BasicNameValuePair("username", username));
        params.add(new BasicNameValuePair("password", Hashing.md5(password)));
        Object apiResult = ApiConnector.doApiRequest("openml.authenticate", "", (HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        if (apiResult instanceof Authenticate) {
            return (Authenticate)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Authenticate");
    }

    public static Data openmlData() throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.data", "");
        if (apiResult instanceof Data) {
            return (Data)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Data");
    }

    public static DataSetDescription openmlDataDescription(int did) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.data.description", "&data_id=" + did);
        if (apiResult instanceof DataSetDescription) {
            return (DataSetDescription)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataSetDescription");
    }

    public static DataFeature openmlDataFeatures(int did) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.data.features", "&data_id=" + did);
        if (apiResult instanceof DataFeature) {
            return (DataFeature)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeature");
    }

    public static DataQuality openmlDataQuality(int did) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.data.qualities", "&data_id=" + did);
        if (apiResult instanceof DataQuality) {
            return (DataQuality)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQuality");
    }

    public static Implementation openmlImplementationGet(int implementation_id) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.implementation.get", "&implementation_id=" + implementation_id);
        if (apiResult instanceof Implementation) {
            return (Implementation)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Implementation");
    }

    public static ImplementationOwned openmlImplementationOwned(String session_hash) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("session_hash", (ContentBody)new StringBody(session_hash));
        Object apiResult = ApiConnector.doApiRequest("openml.implementation.owned", "", (HttpEntity)params);
        if (apiResult instanceof ImplementationOwned) {
            return (ImplementationOwned)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationOwned");
    }

    public static ImplementationDelete openmlImplementationDelete(int id, String session_hash) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("implementation_id", (ContentBody)new StringBody("" + id));
        params.addPart("session_hash", (ContentBody)new StringBody(session_hash));
        Object apiResult = ApiConnector.doApiRequest("openml.implementation.delete", "", (HttpEntity)params);
        if (apiResult instanceof ImplementationDelete) {
            return (ImplementationDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public static ImplementationExists openmlImplementationExists(String name, String external_version) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.implementation.exists", "&name=" + name + "&external_version=" + external_version);
        if (apiResult instanceof ImplementationExists) {
            return (ImplementationExists)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationExists");
    }

    public static Task openmlTasksSearch(int task_id) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.tasks.search", "&task_id=" + task_id);
        if (apiResult instanceof Task) {
            return (Task)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Task");
    }

    public static UploadDataSet openmlDataUpload(File description, File dataset, String session_hash) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (dataset != null) {
            params.addPart("dataset", (ContentBody)new FileBody(dataset));
        }
        params.addPart("session_hash", (ContentBody)new StringBody(session_hash));
        Object apiResult = ApiConnector.doApiRequest("openml.data.upload", "", (HttpEntity)params);
        if (apiResult instanceof UploadDataSet) {
            return (UploadDataSet)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadDataSet");
    }

    public static UploadDataSet openmlDataUpload(File description, String session_hash) throws Exception {
        return ApiConnector.openmlDataUpload(description, null, session_hash);
    }

    public static UploadImplementation openmlImplementationUpload(File description, File binary, File source, String session_hash) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (source != null) {
            params.addPart("source", (ContentBody)new FileBody(source));
        }
        if (binary != null) {
            params.addPart("binary", (ContentBody)new FileBody(binary));
        }
        params.addPart("session_hash", (ContentBody)new StringBody(session_hash));
        Object apiResult = ApiConnector.doApiRequest("openml.implementation.upload", "", (HttpEntity)params);
        if (apiResult instanceof UploadImplementation) {
            return (UploadImplementation)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadImplementation");
    }

    public static UploadRun openmlRunUpload(File description, Map<String, File> output_files, String session_hash) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        for (String s : output_files.keySet()) {
            params.addPart(s, (ContentBody)new FileBody(output_files.get(s)));
        }
        params.addPart("session_hash", (ContentBody)new StringBody(session_hash));
        Object apiResult = ApiConnector.doApiRequest("openml.run.upload", "", (HttpEntity)params);
        if (apiResult instanceof UploadRun) {
            return (UploadRun)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadRun");
    }

    public static Job openmlRunGetjob(String workbench, String task_type_id) throws Exception {
        Object apiResult = ApiConnector.doApiRequest("openml.run.getjob", "&workbench=" + workbench + "&task_type_id=" + task_type_id);
        if (apiResult instanceof Job) {
            return (Job)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Job");
    }

    public static String getStringFromUrl(String url) throws IOException {
        return IOUtils.toString((URL)new URL(url));
    }

    public static File getFileFromUrl(String url, String filepath) throws IOException {
        File file = new File(filepath);
        FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        return file;
    }

    private static Object doApiRequest(String function, String queryString) throws Exception {
        return ApiConnector.doApiRequest(function, queryString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doApiRequest(String function, String queryString, HttpEntity entity) throws Exception {
        String result;
        block10: {
            result = "";
            httpclient = new DefaultHttpClient();
            String requestUri = API_URL + API_PART + "?f=" + function + queryString;
            long contentLength = 0L;
            try {
                HttpResponse response;
                HttpEntity resEntity;
                HttpPost httppost = new HttpPost(requestUri);
                if (entity != null) {
                    httppost.setEntity(entity);
                }
                if ((resEntity = (response = httpclient.execute((HttpUriRequest)httppost)).getEntity()) != null) {
                    result = ApiConnector.httpEntitiToString(resEntity);
                    contentLength = resEntity.getContentLength();
                    break block10;
                }
                throw new Exception("An exception has occured while reading data input stream. ");
            }
            finally {
                try {
                    httpclient.getConnectionManager().shutdown();
                }
                catch (Exception ignore) {}
            }
        }
        Object apiResult = xstream.fromXML(result);
        if (apiResult instanceof ApiError) {
            ApiError apiError = (ApiError)apiResult;
            throw new ApiException(Integer.parseInt(apiError.getCode()), apiError.getMessage());
        }
        return apiResult;
    }

    private static String httpEntitiToString(HttpEntity resEntity) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)new InputStreamReader(resEntity.getContent()), (Writer)writer);
        return writer.toString();
    }
}

