/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import java.io.Serializable;
import java.util.Date;
import org.openml.apiconnector.algorithms.DateParser;
import org.openml.apiconnector.io.ApiConnector;
import org.openml.apiconnector.xml.Authenticate;

public class ApiSessionHash
implements Serializable {
    private static final long serialVersionUID = 7831245113631L;
    private String username = null;
    private String password;
    private String sessionHash = null;
    private long validUntil;

    public boolean isValid() {
        Date utilDate = new Date();
        return this.validUntil > utilDate.getTime() + 300000L;
    }

    public boolean set(String username, String password) {
        this.username = username;
        this.password = password;
        try {
            this.update();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update() throws Exception {
        Authenticate auth = ApiConnector.openmlAuthenticate(this.username, this.password);
        this.validUntil = DateParser.mysqlDateToTimeStamp(auth.getValidUntil());
        this.sessionHash = auth.getSessionHash();
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionHash() throws Exception {
        if (!this.isValid()) {
            this.update();
        }
        return this.sessionHash;
    }

    public static boolean checkCredentials(String username, String password) {
        try {
            ApiConnector.openmlAuthenticate(username, password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

