/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.models;

import java.text.DecimalFormat;

public class MetricScore {
    private Double score = null;
    private Double[] array = null;
    private double[][] confusion_matrix = null;

    public MetricScore(Double score) {
        this.score = score;
    }

    public MetricScore(Double[] array) {
        this.array = array;
    }

    public MetricScore(Double score, Double[] array) {
        this.score = score;
        this.array = array;
    }

    public MetricScore(double[][] confusion_matrix) {
        this.confusion_matrix = confusion_matrix;
    }

    public Double getScore() {
        return this.score;
    }

    public boolean hasArray() {
        return this.array != null || this.confusion_matrix != null;
    }

    public String getArrayAsString(DecimalFormat decimalFormat) {
        StringBuilder sb = new StringBuilder();
        if (this.array != null) {
            for (Double d : this.array) {
                sb.append("," + decimalFormat.format(d));
            }
            return "[" + sb.toString().substring(1) + "]";
        }
        if (this.confusion_matrix != null) {
            for (double[] perClass : this.confusion_matrix) {
                StringBuilder sbperClass = new StringBuilder();
                for (double i : perClass) {
                    sbperClass.append("," + (int)i);
                }
                sb.append(",[" + sbperClass.toString().substring(1) + "]");
            }
            return "[" + sb.toString().substring(1) + "]";
        }
        return null;
    }
}

