/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.settings;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.openml.apiconnector.io.ApiConnector;

public class Config {
    private boolean loaded = false;
    private HashMap<String, String> config;

    public Config() throws IOException {
        this.load("openml.conf");
    }

    public void load(String f) throws IOException {
        this.config = new HashMap();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while (br.ready()) {
            String[] l = br.readLine().split("=");
            if (l.length != 2) continue;
            this.config.put(l[0].trim(), l[1].trim());
        }
        br.close();
        this.loaded = true;
        if (this.getServer() != null) {
            ApiConnector.API_URL = this.getServer();
        }
    }

    public String getUsername() {
        return this.get("username");
    }

    public String getPassword() {
        return this.get("password");
    }

    public String getServer() {
        return this.get("server");
    }

    public String get(String key) {
        if (this.loaded && this.config.containsKey(key)) {
            return this.config.get(key);
        }
        return null;
    }
}

