/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import java.util.Map;

public class DataQuality {
    private final String oml = "http://openml.org/openml";
    private Integer did;
    private Quality[] qualities;

    public DataQuality(Integer did, Quality[] qualities) {
        this.did = did;
        this.qualities = qualities;
    }

    public DataQuality(Integer did, Map<String, Double> qualities) {
        this.did = did;
        this.qualities = new Quality[qualities.size()];
        int iQualityNr = 0;
        for (String quality : qualities.keySet()) {
            this.qualities[iQualityNr] = new Quality(quality, qualities.get(quality) + "");
            ++iQualityNr;
        }
    }

    public Integer getDid() {
        return this.did;
    }

    public Quality[] getQualities() {
        return this.qualities;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public class Quality {
        private String name;
        private String value;

        public Quality(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

