/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.openml.apiconnector.algorithms.ArffHelper;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.Task;

public class TaskInformation {
    public static int getNumberOfRepeats(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_repeats")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_repeats\"");
    }

    public static int getNumberOfSamples(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_samples")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_samples\"");
    }

    public static int getNumberOfFolds(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_folds")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_folds\"");
    }

    public static Task.Input.Estimation_procedure getEstimationProcedure(Task t) throws Exception {
        for (int i = 0; i < t.getInputs().length; ++i) {
            if (!t.getInputs()[i].getName().equals("estimation_procedure")) continue;
            return t.getInputs()[i].getEstimation_procedure();
        }
        throw new Exception("Task does not define an estimation procedure. ");
    }

    public static Task.Input.Data_set getSourceData(Task t) throws Exception {
        for (int i = 0; i < t.getInputs().length; ++i) {
            if (!t.getInputs()[i].getName().equals("source_data")) continue;
            return t.getInputs()[i].getData_set();
        }
        throw new Exception("Task does not define an estimation procedure. ");
    }

    public static Task.Output.Predictions getPredictions(Task t) throws Exception {
        for (int i = 0; i < t.getOutputs().length; ++i) {
            if (!t.getOutputs()[i].getName().equals("predictions")) continue;
            return t.getOutputs()[i].getPredictions();
        }
        throw new Exception("Task does not define an predictions. ");
    }

    public static String[] getClassNames(Task t) throws Exception {
        DataSetDescription dsd = TaskInformation.getSourceData(t).getDataSetDescription();
        String targetFeature = TaskInformation.getSourceData(t).getTarget_feature();
        return TaskInformation.getClassNames(dsd.getDataset(), targetFeature);
    }

    public static String[] getClassNames(File dataset, String targetFeature) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(dataset));
        while ((line = br.readLine()) != null) {
            if (ArffHelper.isDataDeclaration(line)) {
                throw new Exception("Attribute not found.");
            }
            if (!ArffHelper.isAttributeDeclaration(line)) continue;
            try {
                if (!ArffHelper.getAttributeName(line).equals(targetFeature)) continue;
                br.close();
                return ArffHelper.getNominalValues(line);
            }
            catch (Exception e) {
            }
        }
        br.close();
        throw new Exception("Attribute not found.");
    }
}

