/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import java.io.Serializable;
import java.util.Date;
import org.openml.apiconnector.algorithms.DateParser;
import org.openml.apiconnector.io.ApiConnector;
import org.openml.apiconnector.xml.Authenticate;

public class ApiSessionHash
implements Serializable {
    private static final long serialVersionUID = 7831245113631L;
    private final ApiConnector apiconnector;
    private String username;
    private String password;
    private String sessionHash;
    private long validUntil;

    public ApiSessionHash(ApiConnector apiconnector) {
        this.apiconnector = apiconnector;
        this.sessionHash = null;
        this.username = null;
    }

    public boolean isValid() {
        Date utilDate = new Date();
        return this.validUntil > utilDate.getTime() + 300000L;
    }

    public boolean set(String username, String password) {
        this.username = username;
        this.password = password;
        try {
            this.update();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update() throws Exception {
        Authenticate auth = this.apiconnector.openmlAuthenticate(this.username, this.password);
        this.validUntil = DateParser.mysqlDateToTimeStamp(auth.getValidUntil(), auth.getTimezone());
        this.sessionHash = auth.getSessionHash();
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionHash() throws Exception {
        if (!this.isValid()) {
            this.update();
        }
        return this.sessionHash;
    }

    public boolean checkCredentials(String username, String password) {
        try {
            this.apiconnector.openmlAuthenticate(username, password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

