/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.openml.apiconnector.algorithms.ArffHelper;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.Task;

public class TaskInformation {
    public static int getNumberOfRepeats(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_repeats")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_repeats\" (task_id=" + t.getTask_id() + ")");
    }

    public static int getNumberOfSamples(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_samples")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_samples\" (task_id=" + t.getTask_id() + ")");
    }

    public static int getNumberOfFolds(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("number_folds")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"number_folds\" (task_id=" + t.getTask_id() + ")");
    }

    public static Integer getPercentage(Task t) throws Exception {
        Task.Input.Estimation_procedure ep = TaskInformation.getEstimationProcedure(t);
        for (int i = 0; i < ep.getParameters().length; ++i) {
            if (!ep.getParameters()[i].getName().equals("percentage")) continue;
            return Integer.parseInt(ep.getParameters()[i].getValue());
        }
        throw new Exception("Tasks estimation procedure does not contain \"percentage\" (task_id=" + t.getTask_id() + ")");
    }

    public static Task.Input.Estimation_procedure getEstimationProcedure(Task t) throws Exception {
        for (int i = 0; i < t.getInputs().length; ++i) {
            if (!t.getInputs()[i].getName().equals("estimation_procedure")) continue;
            return t.getInputs()[i].getEstimation_procedure();
        }
        throw new Exception("Task does not define an estimation procedure (task_id=" + t.getTask_id() + ")");
    }

    public static double[][] getCostMatrix(Task t) throws Exception {
        for (int i = 0; i < t.getInputs().length; ++i) {
            if (!t.getInputs()[i].getName().equals("cost_matrix")) continue;
            return t.getInputs()[i].getCost_Matrix();
        }
        return null;
    }

    public static Task.Input.Data_set getSourceData(Task t) throws Exception {
        for (int i = 0; i < t.getInputs().length; ++i) {
            if (!t.getInputs()[i].getName().equals("source_data")) continue;
            return t.getInputs()[i].getData_set();
        }
        throw new Exception("Task does not define an estimation procedure (task_id=" + t.getTask_id() + ")");
    }

    public static Task.Output.Predictions getPredictions(Task t) throws Exception {
        for (int i = 0; i < t.getOutputs().length; ++i) {
            if (!t.getOutputs()[i].getName().equals("predictions")) continue;
            return t.getOutputs()[i].getPredictions();
        }
        throw new Exception("Task does not define an predictions (task_id=" + t.getTask_id() + ")");
    }

    public static String[] getClassNames(OpenmlConnector apiconnector, Task t) throws Exception {
        DataSetDescription dsd = TaskInformation.getSourceData(t).getDataSetDescription(apiconnector);
        String targetFeature = TaskInformation.getSourceData(t).getTarget_feature();
        return TaskInformation.getClassNames(dsd.getDataset(apiconnector.getApiKey()), t.getTask_id(), targetFeature);
    }

    public static String[] getClassNames(File dataset, int task_id, String targetFeature) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(dataset));
        while ((line = br.readLine()) != null) {
            if (ArffHelper.isDataDeclaration(line)) {
                throw new Exception("Attribute not found before data declaration (task_id=" + task_id + ")");
            }
            if (!ArffHelper.isAttributeDeclaration(line)) continue;
            try {
                if (!ArffHelper.getAttributeName(line).equals(targetFeature)) continue;
                br.close();
                return ArffHelper.getNominalValues(line);
            }
            catch (Exception exception) {
            }
        }
        br.close();
        throw new Exception("Attribute not found (task_id=" + task_id + ")");
    }
}

