/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.openml.apiconnector.io.ApiException;
import org.openml.apiconnector.xml.ApiError;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class HttpConnector
implements Serializable {
    public static XStream xstreamClient = XstreamXmlMapping.getInstance();
    private static final long serialVersionUID = -8589069573065947493L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doApiRequest(String url, MultipartEntity entity, String ash, int apiVerboseLevel) throws Exception {
        Object apiResult;
        long contentLength;
        String result;
        block11: {
            entity.addPart("api_key", (ContentBody)new StringBody(ash));
            result = "";
            DefaultHttpClient httpclient = new DefaultHttpClient();
            contentLength = 0L;
            try {
                HttpPost httppost = new HttpPost(url);
                httppost.setEntity((HttpEntity)entity);
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = HttpConnector.httpEntitiToString(resEntity);
                    contentLength = resEntity.getContentLength();
                    break block11;
                }
                throw new Exception("An exception has occured while reading data input stream. ");
            }
            finally {
                try {
                    httpclient.getConnectionManager().shutdown();
                }
                catch (Exception httppost) {}
            }
        }
        if (apiVerboseLevel >= 1) {
            System.out.println("===== REQUEST URI (POST): " + url + " (Content Length: " + contentLength + ") =====\n" + result + "\n=====\n");
        }
        if ((apiResult = xstreamClient.fromXML(result)) instanceof ApiError) {
            ApiError apiError = (ApiError)apiResult;
            String message = apiError.getMessage();
            if (apiError.getAdditional_information() != null) {
                message = message + ": " + apiError.getAdditional_information();
            }
            throw new ApiException(Integer.parseInt(apiError.getCode()), message);
        }
        return apiResult;
    }

    public static Object doApiRequest(String url, String ash, int apiVerboseLevel) throws Exception {
        return HttpConnector.doApiRequest(url, new MultipartEntity(), ash, apiVerboseLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doApiDelete(String url, String ash, int apiVerboseLevel) throws Exception {
        Object apiResult;
        long contentLength;
        String result;
        block11: {
            result = "";
            DefaultHttpClient httpclient = new DefaultHttpClient();
            contentLength = 0L;
            try {
                HttpDelete httpdelete = new HttpDelete(url + "?api_key=" + ash);
                HttpResponse response = httpclient.execute((HttpUriRequest)httpdelete);
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = HttpConnector.httpEntitiToString(resEntity);
                    contentLength = resEntity.getContentLength();
                    break block11;
                }
                throw new Exception("An exception has occured while reading data input stream. ");
            }
            finally {
                try {
                    httpclient.getConnectionManager().shutdown();
                }
                catch (Exception httpdelete) {}
            }
        }
        if (apiVerboseLevel >= 1) {
            System.out.println("===== REQUEST URI (DELETE): " + url + " (Content Length: " + contentLength + ") =====\n" + result + "\n=====\n");
        }
        if ((apiResult = xstreamClient.fromXML(result)) instanceof ApiError) {
            ApiError apiError = (ApiError)apiResult;
            String message = apiError.getMessage();
            if (apiError.getAdditional_information() != null) {
                message = message + ": " + apiError.getAdditional_information();
            }
            throw new ApiException(Integer.parseInt(apiError.getCode()), message);
        }
        return apiResult;
    }

    private static String httpEntitiToString(HttpEntity resEntity) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)new InputStreamReader(resEntity.getContent()), (Writer)writer);
        return writer.toString();
    }
}

