/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.models;

import java.text.DecimalFormat;
import org.openml.apiconnector.algorithms.MathHelper;

public class MetricScore {
    private Double score = null;
    private long nr_of_instances = 0L;
    private Double[] array = null;
    private double[][] confusion_matrix = null;

    public MetricScore(Double score, long nr_of_instances) {
        this.score = score;
        this.nr_of_instances = nr_of_instances;
    }

    public MetricScore(Double[] array, long nr_of_instances) {
        this.array = array;
        this.nr_of_instances = nr_of_instances;
    }

    public MetricScore(Double score, Double[] array, long nr_of_instances) {
        this.score = score;
        this.array = array;
        this.nr_of_instances = nr_of_instances;
    }

    public MetricScore(double[][] confusion_matrix) {
        this.confusion_matrix = confusion_matrix;
    }

    public Double getScore() {
        return this.score;
    }

    public boolean hasArray() {
        return this.array != null || this.confusion_matrix != null;
    }

    public long getNrOfInstances() {
        return this.nr_of_instances;
    }

    public String getArrayAsString(DecimalFormat decimalFormat) {
        StringBuilder sb = new StringBuilder();
        if (this.array != null) {
            for (Double d : this.array) {
                if (Double.isNaN(d)) {
                    sb.append(",0.0");
                    continue;
                }
                sb.append("," + decimalFormat.format(d));
            }
            return "[" + sb.toString().substring(1) + "]";
        }
        if (this.confusion_matrix != null) {
            for (double[] perClass : this.confusion_matrix) {
                StringBuilder sbperClass = new StringBuilder();
                for (double i : perClass) {
                    sbperClass.append("," + (int)i);
                }
                sb.append(",[" + sbperClass.toString().substring(1) + "]");
            }
            return "[" + sb.toString().substring(1) + "]";
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.score != null) {
            sb.append(this.score);
        }
        if (this.score != null && this.hasArray()) {
            sb.append(", ");
        }
        if (this.hasArray()) {
            sb.append(this.getArrayAsString(MathHelper.defaultDecimalFormat));
        }
        return "[" + sb.toString() + "]";
    }
}

