/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.algorithms.ArffHelper;

public class DataSetDescription
implements Serializable {
    private static final long serialVersionUID = 987612341129L;
    private final String oml = "http://openml.org/openml";
    private Integer id = null;
    private String name;
    private String version;
    private String description;
    private String format;
    private String[] creator;
    private String[] contributor;
    private String collection_date;
    private String upload_date;
    private String language;
    private String licence;
    private String url;
    private Integer file_id;
    private String row_id_attribute;
    private String default_target_attribute;
    private String[] ignore_attribute;
    private String[] tag;
    private String visibility;
    private String md5_checksum;
    private File dataset_cache;

    public DataSetDescription(String name, String version, String description, String[] creator, String[] contributor, String format, String collection_date, String language, String licence, String row_id_attribute, String default_target_attribute, String[] ignore_attribute, String[] tag, String md5_checksum) {
        this.name = name;
        this.version = version;
        this.description = description;
        this.creator = creator;
        this.contributor = contributor;
        this.format = format;
        this.collection_date = collection_date;
        this.language = language;
        this.upload_date = null;
        this.licence = licence;
        this.url = null;
        this.row_id_attribute = row_id_attribute;
        this.default_target_attribute = default_target_attribute;
        this.ignore_attribute = ignore_attribute;
        this.tag = tag;
        this.md5_checksum = md5_checksum;
    }

    public DataSetDescription(String name, String description, String format, String default_target_attribute) {
        this.name = name;
        this.version = null;
        this.description = description;
        this.creator = null;
        this.contributor = null;
        this.format = format;
        this.collection_date = null;
        this.language = null;
        this.upload_date = null;
        this.licence = null;
        this.url = null;
        this.row_id_attribute = null;
        this.default_target_attribute = default_target_attribute;
        this.md5_checksum = null;
    }

    public DataSetDescription(String name, String description, String format, String default_target_attribute, String visibility) {
        this.name = name;
        this.version = null;
        this.description = description;
        this.creator = null;
        this.contributor = null;
        this.format = format;
        this.collection_date = null;
        this.language = null;
        this.upload_date = null;
        this.licence = null;
        this.url = null;
        this.row_id_attribute = null;
        this.default_target_attribute = default_target_attribute;
        this.visibility = visibility;
        this.md5_checksum = null;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getId() {
        return this.id;
    }

    public void unsetId() {
        this.id = null;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getCreator() {
        return this.creator;
    }

    public String[] getContributor() {
        return this.contributor;
    }

    public String getCollection_date() {
        return this.collection_date;
    }

    public String getUpload_date() {
        return this.upload_date;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLicence() {
        return this.licence;
    }

    public String getUrl() {
        return this.url;
    }

    public void unsetUrl() {
        this.url = null;
    }

    public int getFile_id() {
        return this.file_id;
    }

    public String getRow_id_attribute() {
        return this.row_id_attribute;
    }

    public String getDefault_target_attribute() {
        return this.default_target_attribute;
    }

    public String[] getIgnore_attribute() {
        return this.ignore_attribute;
    }

    public String[] getTag() {
        return this.tag;
    }

    public void addTag(String new_tag) {
        if (this.tag != null && Arrays.asList(this.tag).contains(new_tag)) {
            return;
        }
        this.tag = (String[])ArrayUtils.addAll((Object[])this.tag, (Object[])new String[]{new_tag});
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getMd5_checksum() {
        return this.md5_checksum;
    }

    public File getDataset(String api_key) throws Exception {
        String url_suffix = "";
        if (api_key != null) {
            url_suffix = "?api_key=" + api_key;
        }
        if (this.dataset_cache == null) {
            this.dataset_cache = ArffHelper.downloadAndCache("dataset", this.getId(), this.getUrl() + url_suffix, this.getMd5_checksum());
        }
        return this.dataset_cache;
    }
}

