/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONObject;
import org.openml.apiconnector.algorithms.Caching;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.settings.Settings;
import org.openml.apiconnector.xml.DataDelete;
import org.openml.apiconnector.xml.DataFeature;
import org.openml.apiconnector.xml.DataFeatureUpload;
import org.openml.apiconnector.xml.DataQuality;
import org.openml.apiconnector.xml.DataQualityList;
import org.openml.apiconnector.xml.DataQualityUpload;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.DataTag;
import org.openml.apiconnector.xml.DataUntag;
import org.openml.apiconnector.xml.EvaluationList;
import org.openml.apiconnector.xml.FileUpload;
import org.openml.apiconnector.xml.Flow;
import org.openml.apiconnector.xml.FlowDelete;
import org.openml.apiconnector.xml.FlowExists;
import org.openml.apiconnector.xml.FlowOwned;
import org.openml.apiconnector.xml.FlowTag;
import org.openml.apiconnector.xml.FlowUntag;
import org.openml.apiconnector.xml.Job;
import org.openml.apiconnector.xml.Run;
import org.openml.apiconnector.xml.RunDelete;
import org.openml.apiconnector.xml.RunEvaluate;
import org.openml.apiconnector.xml.RunList;
import org.openml.apiconnector.xml.RunReset;
import org.openml.apiconnector.xml.RunTag;
import org.openml.apiconnector.xml.RunTrace;
import org.openml.apiconnector.xml.RunUntag;
import org.openml.apiconnector.xml.SetupDelete;
import org.openml.apiconnector.xml.SetupDifferences;
import org.openml.apiconnector.xml.SetupParameters;
import org.openml.apiconnector.xml.SetupTag;
import org.openml.apiconnector.xml.SetupUntag;
import org.openml.apiconnector.xml.Task;
import org.openml.apiconnector.xml.TaskDelete;
import org.openml.apiconnector.xml.TaskTag;
import org.openml.apiconnector.xml.TaskUntag;
import org.openml.apiconnector.xml.UploadDataSet;
import org.openml.apiconnector.xml.UploadFlow;
import org.openml.apiconnector.xml.UploadRun;
import org.openml.apiconnector.xml.UploadTask;

public class OpenmlConnector
implements Serializable {
    private static final long serialVersionUID = 7362620508675762264L;
    private int verboseLevel = 0;
    private String api_key;
    private final String OPENML_URL;
    private static final String API_PART = "api_new/v1/";
    private boolean apiKeySet = false;

    public OpenmlConnector(String url, String api_key) {
        this.OPENML_URL = url != null ? url : "http://www.openml.org/";
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public OpenmlConnector(String api_key) {
        this.OPENML_URL = "http://www.openml.org/";
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public OpenmlConnector() {
        this.OPENML_URL = "http://www.openml.org/";
    }

    public String getApiKey() {
        if (this.apiKeySet) {
            return this.api_key;
        }
        return null;
    }

    public void setApiKey(String api_key) {
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public int getVerboselevel() {
        return this.verboseLevel;
    }

    public String getApiUrl() {
        return this.OPENML_URL + API_PART;
    }

    public File getXSD(String name) throws IOException {
        File file = File.createTempFile("name", "xsd");
        file.deleteOnExit();
        URL url = new URL(this.getApiUrl() + "xsd/" + name + "?api_key=" + this.getApiKey());
        FileUtils.copyURLToFile((URL)url, (File)file);
        return file;
    }

    public DataSetDescription dataGet(int did) throws Exception {
        if (Caching.in_cache("datadescription", did, "xml") || Settings.LOCAL_OPERATIONS) {
            String dsdString = Conversion.fileToString(Caching.cached("datadescription", did, "xml"));
            return (DataSetDescription)HttpConnector.xstreamClient.fromXML(dsdString);
        }
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/" + did, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataSetDescription) {
            if (Settings.CACHE_ALLOWED) {
                try {
                    Caching.cache(apiResult, "datadescription", did, "xml");
                }
                catch (IOException e) {
                    Conversion.log("Warning", "DataGet", "Cache Store Exception: " + e.getMessage());
                }
            }
            return (DataSetDescription)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataSetDescription");
    }

    public UploadDataSet dataUpload(File description, File dataset) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (dataset != null) {
            params.addPart("dataset", (ContentBody)new FileBody(dataset));
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/", params, this.getApiKey(), this.verboseLevel)) instanceof UploadDataSet) {
            return (UploadDataSet)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadDataSet");
    }

    public DataDelete dataDelete(int did) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "data/" + did, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataDelete) {
            return (DataDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataDelete");
    }

    public DataTag dataTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("data_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/tag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataTag) {
            return (DataTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataTag");
    }

    public DataUntag dataUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("data_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/untag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataUntag) {
            return (DataUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataUntag");
    }

    public DataFeature dataFeatures(int did) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/features/" + did, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataFeature) {
            return (DataFeature)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeature");
    }

    public DataQuality dataQualities(int did) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/qualities/" + did, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQuality) {
            return (DataQuality)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQuality");
    }

    public DataFeatureUpload dataFeaturesUpload(File description) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(description) + "\n==========\n");
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/features", params, this.getApiKey(), this.verboseLevel)) instanceof DataFeatureUpload) {
            return (DataFeatureUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeatureUpload");
    }

    public DataQualityUpload dataQualitiesUpload(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/qualities", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQualityUpload) {
            return (DataQualityUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityUpload");
    }

    public DataQualityList dataQualitiesList() throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "data/qualities/list", this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQualityList) {
            return (DataQualityList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityList");
    }

    public Task taskGet(int task_id) throws Exception {
        if (Caching.in_cache("task", task_id, "xml") || Settings.LOCAL_OPERATIONS) {
            String taskXml = Conversion.fileToString(Caching.cached("task", task_id, "xml"));
            return (Task)HttpConnector.xstreamClient.fromXML(taskXml);
        }
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "task/" + task_id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Task) {
            if (Settings.CACHE_ALLOWED) {
                try {
                    Caching.cache(apiResult, "task", task_id, "xml");
                }
                catch (IOException e) {
                    Conversion.log("Warning", "TaskGet", "Cache Store Exception: " + e.getMessage());
                }
            }
            return (Task)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Task");
    }

    public TaskDelete taskDelete(int task_id) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "task/" + task_id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskDelete) {
            return (TaskDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskDelete");
    }

    public UploadTask taskUpload(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "task/", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof UploadTask) {
            return (UploadTask)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadTask");
    }

    public TaskTag taskTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "task/tag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskTag) {
            return (TaskTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskTag");
    }

    public TaskUntag taskUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "task/untag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskUntag) {
            return (TaskUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskUntag");
    }

    public Flow flowGet(int flow_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow/" + flow_id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Flow) {
            return (Flow)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Implementation");
    }

    public FlowTag flowTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("flow_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow/tag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowTag) {
            return (FlowTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to FlowTag");
    }

    public FlowUntag flowUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("flow_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow/untag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowUntag) {
            return (FlowUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to FlowUntag");
    }

    public FlowOwned flowOwned() throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow/owned", this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowOwned) {
            return (FlowOwned)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationOwned");
    }

    public FlowDelete flowDelete(int id) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "flow/" + id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowDelete) {
            return (FlowDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public FlowDelete flowForceDelete(int id) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "flow/" + id + "/force", this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowDelete) {
            return (FlowDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public FlowExists flowExists(String name, String external_version) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow/exists/" + name + "/" + external_version, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowExists) {
            return (FlowExists)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationExists");
    }

    public UploadFlow flowUpload(File description, File binary, File source) throws Exception {
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (source != null) {
            params.addPart("source", (ContentBody)new FileBody(source));
        }
        if (binary != null) {
            params.addPart("binary", (ContentBody)new FileBody(binary));
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "flow", params, this.getApiKey(), this.verboseLevel)) instanceof UploadFlow) {
            return (UploadFlow)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadImplementation");
    }

    public UploadRun runUpload(File description, Map<String, File> output_files) throws Exception {
        MultipartEntity params = new MultipartEntity();
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(output_files.get("predictions")) + "\n==========\n");
        }
        if (this.verboseLevel >= 1) {
            System.out.println(Conversion.fileToString(description) + "\n==========");
        }
        params.addPart("description", (ContentBody)new FileBody(description));
        for (String s : output_files.keySet()) {
            params.addPart(s, (ContentBody)new FileBody(output_files.get(s)));
        }
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof UploadRun) {
            return (UploadRun)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadRun");
    }

    public RunList runList(List<Integer> task_id, List<Integer> setup_id) throws Exception {
        Object apiResult;
        String suffix = "";
        if (task_id != null) {
            suffix = suffix + "/task/" + StringUtils.join(task_id, (char)',');
        }
        if (setup_id != null) {
            suffix = suffix + "/setup/" + StringUtils.join(setup_id, (char)',');
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/list" + suffix, this.getApiKey(), this.verboseLevel)) instanceof RunList) {
            return (RunList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunList");
    }

    public EvaluationList evaluationList(List<Integer> task_id, List<Integer> setup_id, String function) throws Exception {
        Object apiResult;
        String suffix = "";
        if (task_id != null) {
            suffix = suffix + "/task/" + StringUtils.join(task_id, (char)',');
        }
        if (setup_id != null) {
            suffix = suffix + "/setup/" + StringUtils.join(setup_id, (char)',');
        }
        if (function != null) {
            suffix = suffix + "/function/" + function;
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "evaluation/list" + suffix, this.getApiKey(), this.verboseLevel)) instanceof EvaluationList) {
            return (EvaluationList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to EvaluationList");
    }

    public RunTag runTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/tag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunTag) {
            return (RunTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunTag");
    }

    public RunUntag runUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/untag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunUntag) {
            return (RunUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunUntag");
    }

    public RunEvaluate runEvaluate(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/evaluate", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunEvaluate) {
            return (RunEvaluate)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunEvaluate");
    }

    public RunTrace runTrace(File trace) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("trace", (ContentBody)new FileBody(trace));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/trace", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunTrace) {
            return (RunTrace)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunTrace");
    }

    public Run runGet(int runId) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/" + runId, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Run) {
            return (Run)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Task");
    }

    public RunDelete runDelete(int id) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "run/" + id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunDelete) {
            return (RunDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunDelete");
    }

    public RunReset runReset(int run_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "run/reset/" + run_id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunReset) {
            return (RunReset)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunReset");
    }

    public SetupParameters setupParameters(int setup_id) throws Exception {
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "setup/" + setup_id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupParameters) {
            return (SetupParameters)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupParameters");
    }

    public SetupTag setupTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("setup_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "setup/tag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupTag) {
            return (SetupTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupTag");
    }

    public SetupUntag setupUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("setup_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "setup/untag", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupUntag) {
            return (SetupUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupUntag");
    }

    public SetupDelete setupDelete(int id) throws Exception {
        Object apiResult = HttpConnector.doApiDelete(this.OPENML_URL + API_PART + "setup/" + id, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupDelete) {
            return (SetupDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDelete");
    }

    public SetupDifferences setupDifferences(int setupA, int setupB, int task_id, int task_size, int differences) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + task_id));
        params.addPart("task_size", (ContentBody)new StringBody("" + task_size));
        params.addPart("differences", (ContentBody)new StringBody("" + differences));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "setup/differences/" + setupA + "/" + setupB, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupDifferences) {
            return (SetupDifferences)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDifferences");
    }

    public SetupDifferences setupDifferences(Integer setupA, Integer setupB, Integer task_id) throws Exception {
        Object apiResult;
        String suffix = setupA + "/" + setupB;
        if (task_id != null) {
            suffix = suffix + "/" + task_id;
        }
        if ((apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "setup/differences/" + suffix, this.getApiKey(), this.verboseLevel)) instanceof SetupDifferences) {
            return (SetupDifferences)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDifferences");
    }

    public FileUpload fileUpload(File file) throws Exception {
        MultipartEntity params = new MultipartEntity();
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(file) + "\n==========\n");
        }
        params.addPart("file", (ContentBody)new FileBody(file));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "file/upload", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FileUpload) {
            return (FileUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadFile");
    }

    public Job jobRequest(String workbench, String task_type_id) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("workbench", (ContentBody)new StringBody(workbench));
        params.addPart("task_type_id", (ContentBody)new StringBody(task_type_id));
        Object apiResult = HttpConnector.doApiRequest(this.OPENML_URL + API_PART + "job/request", params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Job) {
            return (Job)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Job");
    }

    public JSONObject freeQuery(String sql) throws Exception {
        String res = OpenmlConnector.getStringFromUrl(this.OPENML_URL + "api_query/?q=" + URLEncoder.encode(sql, "ISO-8859-1") + "&hash=" + this.getApiKey());
        if (this.verboseLevel >= 1) {
            System.out.println(res + "\n==========\n");
        }
        return new JSONObject(res);
    }

    public static String getStringFromUrl(String url) throws IOException {
        String result = IOUtils.toString((URL)new URL(url));
        return result;
    }

    public static File getFileFromUrl(URL url, String filepath) throws IOException {
        File file = new File(filepath);
        FileUtils.copyURLToFile((URL)url, (File)file);
        return file;
    }

    public URL getOpenmlFileUrl(int id, String filename) throws Exception {
        if (filename == null) {
            filename = "file";
        }
        String suffix = this.api_key == null ? "" : "?api_key=" + this.getApiKey();
        return new URL(this.OPENML_URL + "data/download/" + id + "/" + URLEncoder.encode(filename, "UTF-8") + suffix);
    }
}

