/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.openml.apiconnector.algorithms.Caching;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.algorithms.Hashing;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.settings.Settings;

public class ArffHelper {
    public static File downloadAndCache(String type, int identifier, String extension, URL url, String serverMd5) throws Exception {
        if (Caching.in_cache(url, type, identifier, extension)) {
            File file = Caching.cached(url, type, identifier, extension);
            String clientMd5 = Hashing.md5(file);
            if (serverMd5 == null || serverMd5.equals("NotApplicable") || clientMd5.equals(serverMd5.trim())) {
                return file;
            }
            Conversion.log("WARNING", "ARFF Cache", type + " " + identifier + " hash and cache not identical: \n- Client: " + clientMd5 + "\n- Server: " + serverMd5);
        }
        if (Settings.LOCAL_OPERATIONS) {
            throw new IOException("Cache file of " + type + " #" + identifier + " not available, and only local operations are allowed. ");
        }
        File dataset = Settings.CACHE_ALLOWED ? Caching.cache(url, type, identifier, extension) : Conversion.stringToTempFile(HttpConnector.getStringFromUrl(url, false), type + "_" + identifier + "", extension);
        String hash = Hashing.md5(dataset);
        if (serverMd5 == null || serverMd5.equals("NotApplicable") || hash.equals(serverMd5.trim())) {
            return dataset;
        }
        throw new IOException("Hash of the downloaded file does not correspond to the server hash");
    }

    public static boolean isDataDeclaration(String line) {
        if (line.length() == 0) {
            return false;
        }
        if (line.charAt(0) == '%') {
            return false;
        }
        return line.toUpperCase().contains("@DATA");
    }

    public static boolean isAttributeDeclaration(String line) {
        if (line.length() == 0) {
            return false;
        }
        if (line.charAt(0) == '%') {
            return false;
        }
        return line.toUpperCase().contains("@ATTRIBUTE");
    }

    public static String getAttributeName(String attributeLine) throws Exception {
        if (!ArffHelper.isAttributeDeclaration(attributeLine)) {
            throw new Exception("Not a valid attribute. ");
        }
        String[] words = attributeLine.trim().split("\\s+");
        if (words.length < 2) {
            throw new Exception("Not a valid attribute.");
        }
        if (words[1].charAt(0) == '\'' && words[1].charAt(words[1].length() - 1) == '\'') {
            return words[1].substring(1, words[1].length() - 1);
        }
        return words[1];
    }

    public static String[] getNominalValues(String attributeLine) throws Exception {
        if (!ArffHelper.isAttributeDeclaration(attributeLine)) {
            throw new Exception("Not a valid attribute. ");
        }
        int idxStartBracket = attributeLine.indexOf(123);
        int idxEndBracket = attributeLine.indexOf(125);
        if (idxStartBracket == -1 || idxEndBracket == -1) {
            throw new Exception("Not a nominal attribute. ");
        }
        if (idxStartBracket > idxEndBracket) {
            throw new Exception("Not a legal nominal attribute. ");
        }
        String[] classes = attributeLine.substring(idxStartBracket + 1, idxEndBracket).split(",");
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = classes[i].trim();
            if (classes[i].charAt(0) != '\'' || classes[i].charAt(classes[i].length() - 1) != '\'') continue;
            classes[i] = classes[i].substring(1, classes[i].length() - 1);
        }
        return classes;
    }
}

