/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openml.apiconnector.algorithms.DateParser;
import org.xml.sax.SAXException;

public class Conversion {
    public static File stringToTempFile(String string, String filename, String format, File directory) throws IOException {
        File file = File.createTempFile(filename, '.' + format, directory);
        BufferedWriter br = new BufferedWriter(new FileWriter(file));
        br.write(string);
        br.close();
        file.deleteOnExit();
        return file;
    }

    public static File stringToTempFile(String string, String filename, String format) throws IOException {
        return Conversion.stringToTempFile(string, filename, format, null);
    }

    public static int[] commaSeparatedStringToIntArray(String commaSeparated) throws NumberFormatException {
        String[] splitted = commaSeparated.replaceAll("\\s", "").split(",");
        int[] result = new int[splitted.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(splitted[i]);
        }
        return result;
    }

    public static String fileToString(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuilder sb = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            sb.append(line + "\n");
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void log(String status, String action, String message) {
        Conversion.log(status, action, message, System.err);
    }

    public static void log(String status, String action, String message, PrintStream writer) {
        writer.println("[" + DateParser.humanReadable.format(System.currentTimeMillis()) + "] [" + status + "] [" + action + "] " + message);
    }

    public static double percentage(int observation, int total) {
        return (double)observation / (double)total * 100.0;
    }

    public static boolean validateXML(File xml, File xsd) throws SAXException, IOException {
        StreamSource xmlFile = new StreamSource(xml);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(xsd);
        Validator validator = schema.newValidator();
        try {
            validator.validate(xmlFile);
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }
}

