/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.algorithms;

import java.io.Serializable;
import jnt.scimark2.Random;
import jnt.scimark2.kernel;
import org.apache.commons.lang3.StringUtils;
import org.openml.apiconnector.algorithms.Conversion;

public class SciMark
implements Serializable {
    private static SciMark instance = null;
    private static final long serialVersionUID = -5563065042084199486L;
    private boolean benchmarkDone = false;
    private double[] results = new double[5];
    private double average;
    String[] os = new String[5];

    public static void main(String[] args) {
        SciMark scimark = new SciMark();
        String[] d = scimark.getOsInfo();
        System.out.println("Operating System: " + d[3] + " v" + d[4] + "\nJava version: " + d[1] + " by " + d[0] + "\nSystem architecture: " + d[2]);
        System.out.println("Composite score: " + scimark.doBenchmark());
        System.out.println("[ " + StringUtils.join((Object[])scimark.getStringArray(), (String)", ") + " ]");
    }

    public static SciMark getInstance() {
        if (instance == null) {
            instance = new SciMark();
        }
        return instance;
    }

    public SciMark() {
        this.os[0] = System.getProperty("java.vendor");
        this.os[1] = System.getProperty("java.version");
        this.os[2] = System.getProperty("os.arch");
        this.os[3] = System.getProperty("os.name");
        this.os[4] = System.getProperty("os.version");
    }

    public double doBenchmark() {
        Conversion.log("INFO", "SciMark Benchmark", "Doing JVM Benchmark.");
        double min_time = 2.0;
        int FFT_size = 1024;
        int SOR_size = 100;
        int Sparse_size_M = 1000;
        int Sparse_size_nz = 5000;
        int LU_size = 100;
        Random R = new Random(101010);
        this.results[0] = kernel.measureFFT((int)FFT_size, (double)min_time, (Random)R);
        this.results[1] = kernel.measureSOR((int)SOR_size, (double)min_time, (Random)R);
        this.results[2] = kernel.measureMonteCarlo((double)min_time, (Random)R);
        this.results[3] = kernel.measureSparseMatmult((int)Sparse_size_M, (int)Sparse_size_nz, (double)min_time, (Random)R);
        this.results[4] = kernel.measureLU((int)LU_size, (double)min_time, (Random)R);
        this.average = (this.results[0] + this.results[1] + this.results[2] + this.results[3] + this.results[4]) / 5.0;
        this.benchmarkDone = true;
        return this.average;
    }

    public String[] getOsInfo() {
        return this.os;
    }

    public String[] getStringArray() {
        String[] res = new String[this.results.length];
        for (int i = 0; i < this.results.length; ++i) {
            res[i] = "" + this.results[i];
        }
        return res;
    }

    public double getResult() {
        if (!this.benchmarkDone) {
            this.doBenchmark();
        }
        return this.average;
    }
}

