/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.openml.apiconnector.io.ApiException;
import org.openml.apiconnector.xml.ApiError;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class HttpConnector
implements Serializable {
    private static final long serialVersionUID = -8589069573065947493L;

    public static Object doApiRequest(URL url, MultipartEntity entity, String ash, int apiVerboseLevel) throws Exception {
        if (ash == null) {
            throw new Exception("Api key not set. ");
        }
        entity.addPart("api_key", (ContentBody)new StringBody(ash));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(url.toString());
        httppost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        return HttpConnector.wrapHttpResponse(response, url, "POST", apiVerboseLevel);
    }

    public static Object doApiRequest(URL url, String ash, int apiVerboseLevel) throws Exception {
        if (ash != null) {
            url = new URL(url + "?api_key=" + ash);
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url.toString());
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        return HttpConnector.wrapHttpResponse(response, url, "GET", apiVerboseLevel);
    }

    public static Object doApiDelete(URL url, String ash, int apiVerboseLevel) throws Exception {
        if (ash == null) {
            throw new Exception("Api key not set. ");
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpDelete httpdelete = new HttpDelete(url + "?api_key=" + ash);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpdelete);
        return HttpConnector.wrapHttpResponse(response, url, "DELETE", apiVerboseLevel);
    }

    public static String getStringFromUrl(URL url, boolean accept_all) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url.toString());
        CloseableHttpResponse httpResp = client.execute((HttpUriRequest)httpget);
        int code = httpResp.getStatusLine().getStatusCode();
        if (!accept_all && code != 200) {
            throw new IOException("Problem getting URL, status " + code + ": " + url);
        }
        return HttpConnector.httpEntitiToString(httpResp.getEntity());
    }

    private static Object wrapHttpResponse(CloseableHttpResponse response, URL url, String requestType, int apiVerboseLevel) throws Exception {
        String result = HttpConnector.readHttpResponse(response, url, requestType, apiVerboseLevel);
        XStream xstreamClient = XstreamXmlMapping.getInstance();
        Object apiResult = xstreamClient.fromXML(result);
        if (apiResult instanceof ApiError) {
            ApiError apiError = (ApiError)apiResult;
            String message = apiError.getMessage();
            if (apiError.getAdditional_information() != null) {
                message = message + ": " + apiError.getAdditional_information();
            }
            throw new ApiException(Integer.parseInt(apiError.getCode()), message);
        }
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readHttpResponse(CloseableHttpResponse response, URL url, String requestType, int apiVerboseLevel) throws Exception {
        long contentLength;
        int code;
        String result;
        block9: {
            result = "";
            HttpEntity resEntity = response.getEntity();
            code = response.getStatusLine().getStatusCode();
            contentLength = 0L;
            try {
                if (resEntity != null) {
                    result = HttpConnector.httpEntitiToString(resEntity);
                    contentLength = resEntity.getContentLength();
                    break block9;
                }
                throw new IOException("An exception has occured while reading data input stream. ");
            }
            finally {
                try {
                    response.close();
                }
                catch (Exception exception) {}
            }
        }
        if (apiVerboseLevel >= 1) {
            System.out.println("===== REQUEST URI (" + requestType + "): " + url + " (Status Code: " + code + ", Content Length: " + contentLength + ") =====\n" + result + "\n=====\n");
        }
        return result;
    }

    public static File getFileFromUrl(URL url, String filepath, boolean accept_all) throws IOException, URISyntaxException {
        File file = new File(filepath);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpget = new HttpGet(url.toURI());
        HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
        int code = response.getStatusLine().getStatusCode();
        if (!accept_all && code != 200) {
            throw new IOException("Problem getting URL, status " + code + ": " + url);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            FileOutputStream fos = new FileOutputStream(file);
            entity.writeTo((OutputStream)fos);
            fos.close();
        }
        return file;
    }

    protected static String httpEntitiToString(HttpEntity resEntity) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)new InputStreamReader(resEntity.getContent()), (Writer)writer);
        return writer.toString();
    }
}

