/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.openml.apiconnector.algorithms.Caching;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.settings.Settings;
import org.openml.apiconnector.xml.Data;
import org.openml.apiconnector.xml.DataDelete;
import org.openml.apiconnector.xml.DataFeature;
import org.openml.apiconnector.xml.DataFeatureUpload;
import org.openml.apiconnector.xml.DataQuality;
import org.openml.apiconnector.xml.DataQualityList;
import org.openml.apiconnector.xml.DataQualityUpload;
import org.openml.apiconnector.xml.DataSetDescription;
import org.openml.apiconnector.xml.DataTag;
import org.openml.apiconnector.xml.DataUnprocessed;
import org.openml.apiconnector.xml.DataUntag;
import org.openml.apiconnector.xml.EvaluationList;
import org.openml.apiconnector.xml.EvaluationRequest;
import org.openml.apiconnector.xml.FileUpload;
import org.openml.apiconnector.xml.Flow;
import org.openml.apiconnector.xml.FlowDelete;
import org.openml.apiconnector.xml.FlowExists;
import org.openml.apiconnector.xml.FlowTag;
import org.openml.apiconnector.xml.FlowUntag;
import org.openml.apiconnector.xml.Job;
import org.openml.apiconnector.xml.Run;
import org.openml.apiconnector.xml.RunDelete;
import org.openml.apiconnector.xml.RunEvaluate;
import org.openml.apiconnector.xml.RunList;
import org.openml.apiconnector.xml.RunReset;
import org.openml.apiconnector.xml.RunTag;
import org.openml.apiconnector.xml.RunTrace;
import org.openml.apiconnector.xml.RunTraceUpload;
import org.openml.apiconnector.xml.RunUntag;
import org.openml.apiconnector.xml.SetupDelete;
import org.openml.apiconnector.xml.SetupDifferences;
import org.openml.apiconnector.xml.SetupExists;
import org.openml.apiconnector.xml.SetupParameters;
import org.openml.apiconnector.xml.SetupTag;
import org.openml.apiconnector.xml.SetupUntag;
import org.openml.apiconnector.xml.Study;
import org.openml.apiconnector.xml.Task;
import org.openml.apiconnector.xml.TaskDelete;
import org.openml.apiconnector.xml.TaskInputs;
import org.openml.apiconnector.xml.TaskTag;
import org.openml.apiconnector.xml.TaskUntag;
import org.openml.apiconnector.xml.Tasks;
import org.openml.apiconnector.xml.UploadDataSet;
import org.openml.apiconnector.xml.UploadFlow;
import org.openml.apiconnector.xml.UploadRun;
import org.openml.apiconnector.xml.UploadRunAttach;
import org.openml.apiconnector.xml.UploadTask;
import org.openml.apiconnector.xstream.XstreamXmlMapping;

public class OpenmlConnector
implements Serializable {
    private static final long serialVersionUID = 7362620508675762264L;
    private int verboseLevel = 0;
    private String api_key;
    private final String OPENML_URL;
    private String API_PART = "api_new/v1/";
    private boolean apiKeySet = false;

    public OpenmlConnector(String url, String api_key, boolean useJson) {
        this.OPENML_URL = url != null ? url : "https://www.openml.org/";
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
        if (useJson) {
            this.API_PART = this.API_PART + "json/";
        }
    }

    public OpenmlConnector(String url, String api_key) {
        this.OPENML_URL = url != null ? url : "https://www.openml.org/";
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public OpenmlConnector(String api_key) {
        this.OPENML_URL = "https://www.openml.org/";
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public OpenmlConnector() {
        this.OPENML_URL = "https://www.openml.org/";
    }

    public String getApiKey() {
        if (this.apiKeySet) {
            return this.api_key;
        }
        return null;
    }

    public void setApiKey(String api_key) {
        this.api_key = api_key;
        if (api_key != null) {
            this.apiKeySet = true;
        }
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public int getVerboselevel() {
        return this.verboseLevel;
    }

    public String getApiUrl() {
        return this.OPENML_URL + this.API_PART;
    }

    public File getXSD(String name) throws IOException {
        File file = File.createTempFile("name", "xsd");
        file.deleteOnExit();
        URL url = new URL(this.getApiUrl() + "xsd/" + name + "?api_key=" + this.getApiKey());
        FileUtils.copyURLToFile((URL)url, (File)file);
        return file;
    }

    public DataSetDescription dataGet(int did) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/" + did);
        if (Caching.in_cache(request, "datadescription", did, "xml") || Settings.LOCAL_OPERATIONS) {
            String dsdString = Conversion.fileToString(Caching.cached(request, "datadescription", did, "xml"));
            return (DataSetDescription)XstreamXmlMapping.getInstance().fromXML(dsdString);
        }
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataSetDescription) {
            if (Settings.CACHE_ALLOWED) {
                try {
                    Caching.cache(request, apiResult, "datadescription", did, "xml");
                }
                catch (IOException e) {
                    Conversion.log("Warning", "DataGet", "Cache Store Exception: " + e.getMessage());
                }
            }
            return (DataSetDescription)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataSetDescription");
    }

    public UploadDataSet dataUpload(File description, File dataset) throws Exception {
        URL request;
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (dataset != null) {
            params.addPart("dataset", (ContentBody)new FileBody(dataset));
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "data/"), params, this.getApiKey(), this.verboseLevel)) instanceof UploadDataSet) {
            return (UploadDataSet)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadDataSet");
    }

    public DataDelete dataDelete(int did) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/" + did);
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataDelete) {
            return (DataDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataDelete");
    }

    public DataTag dataTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("data_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/tag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataTag) {
            return (DataTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataTag");
    }

    public DataUntag dataUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("data_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/untag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataUntag) {
            return (DataUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataUntag");
    }

    public DataFeature dataFeatures(int did) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/features/" + did);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataFeature) {
            return (DataFeature)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeature");
    }

    public Data dataList(Map<String, String> filters) throws Exception {
        URL request;
        Object apiResult;
        String suffix = "";
        if (filters != null) {
            for (String filter : filters.keySet()) {
                suffix = suffix + filter + "/" + filters.get(filter) + "/";
            }
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "data/list/" + suffix), this.getApiKey(), this.verboseLevel)) instanceof Data) {
            return (Data)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Data");
    }

    public DataQuality dataQualities(int did) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/qualities/" + did);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQuality) {
            return (DataQuality)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQuality");
    }

    public DataFeatureUpload dataFeaturesUpload(File description) throws Exception {
        URL request;
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(description) + "\n==========\n");
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "data/features"), params, this.getApiKey(), this.verboseLevel)) instanceof DataFeatureUpload) {
            return (DataFeatureUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataFeatureUpload");
    }

    public DataQualityUpload dataQualitiesUpload(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/qualities");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQualityUpload) {
            return (DataQualityUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityUpload");
    }

    public DataQualityList dataQualitiesList() throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "data/qualities/list");
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataQualityList) {
            return (DataQualityList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataQualityList");
    }

    public DataUnprocessed dataUnprocessed(int evaluationEngineId, String mode) throws Exception {
        String suffix = "data/unprocessed/" + evaluationEngineId + "/" + mode;
        URL request = new URL(this.OPENML_URL + this.API_PART + suffix);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof DataUnprocessed) {
            return (DataUnprocessed)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataUnprocessed");
    }

    public DataUnprocessed dataqualitiesUnprocessed(int evaluationEngineId, String mode, boolean featureQualities, List<String> qualitiesToCalculate) throws Exception {
        URL request;
        Object apiResult;
        StringBuilder sb = new StringBuilder();
        for (String s : qualitiesToCalculate) {
            sb.append("," + s);
        }
        MultipartEntity params = new MultipartEntity();
        params.addPart("qualities", (ContentBody)new StringBody(sb.toString().substring(1)));
        String suffix = "data/qualities/unprocessed/" + evaluationEngineId + "/" + mode;
        if (featureQualities) {
            suffix = suffix + "/features";
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + suffix), params, this.getApiKey(), this.verboseLevel)) instanceof DataUnprocessed) {
            return (DataUnprocessed)apiResult;
        }
        throw new DataFormatException("Casting Api Object to DataUnprocessed");
    }

    public Task taskGet(int task_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/" + task_id);
        if (Caching.in_cache(request, "task", task_id, "xml") || Settings.LOCAL_OPERATIONS) {
            String taskXml = Conversion.fileToString(Caching.cached(request, "task", task_id, "xml"));
            return (Task)XstreamXmlMapping.getInstance().fromXML(taskXml);
        }
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Task) {
            if (Settings.CACHE_ALLOWED) {
                try {
                    Caching.cache(request, apiResult, "task", task_id, "xml");
                }
                catch (IOException e) {
                    Conversion.log("Warning", "TaskGet", "Cache Store Exception: " + e.getMessage());
                }
            }
            return (Task)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Task");
    }

    public TaskInputs taskInputs(int task_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/inputs/" + task_id);
        this.setVerboseLevel(1);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskInputs) {
            return (TaskInputs)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskInputs");
    }

    public Tasks taskList(String tag) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/list/tag/" + tag);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Tasks) {
            return (Tasks)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Tasks");
    }

    public Tasks taskList(int type, String tag) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/list/tag/" + tag + "/type/" + type + "/");
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Tasks) {
            return (Tasks)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Tasks");
    }

    public TaskDelete taskDelete(int task_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/" + task_id);
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskDelete) {
            return (TaskDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskDelete");
    }

    public UploadTask taskUpload(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof UploadTask) {
            return (UploadTask)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadTask");
    }

    public TaskTag taskTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/tag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskTag) {
            return (TaskTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskTag");
    }

    public TaskUntag taskUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "task/untag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof TaskUntag) {
            return (TaskUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to TaskUntag");
    }

    public Flow flowGet(int flow_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/" + flow_id);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Flow) {
            return (Flow)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Implementation");
    }

    public FlowTag flowTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("flow_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/tag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowTag) {
            return (FlowTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to FlowTag");
    }

    public FlowUntag flowUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("flow_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/untag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowUntag) {
            return (FlowUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to FlowUntag");
    }

    public FlowDelete flowDelete(int id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/" + id);
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowDelete) {
            return (FlowDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public FlowDelete flowForceDelete(int id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/" + id + "/force");
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowDelete) {
            return (FlowDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationDelete");
    }

    public FlowExists flowExists(String name, String external_version) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "flow/exists/" + name + "/" + external_version);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FlowExists) {
            return (FlowExists)apiResult;
        }
        throw new DataFormatException("Casting Api Object to ImplementationExists");
    }

    public UploadFlow flowUpload(File description, File binary, File source) throws Exception {
        URL request;
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        if (source != null) {
            params.addPart("source", (ContentBody)new FileBody(source));
        }
        if (binary != null) {
            params.addPart("binary", (ContentBody)new FileBody(binary));
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "flow"), params, this.getApiKey(), this.verboseLevel)) instanceof UploadFlow) {
            return (UploadFlow)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadImplementation");
    }

    public UploadRun runUpload(File description, Map<String, File> output_files) throws Exception {
        URL request;
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(output_files.get("predictions")) + "\n==========\n");
        }
        if (this.verboseLevel >= 1) {
            System.out.println(Conversion.fileToString(description) + "\n==========");
        }
        params.addPart("description", (ContentBody)new FileBody(description));
        if (output_files != null) {
            for (String s : output_files.keySet()) {
                params.addPart(s, (ContentBody)new FileBody(output_files.get(s)));
            }
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "run/"), params, this.getApiKey(), this.verboseLevel)) instanceof UploadRun) {
            return (UploadRun)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadRun");
    }

    public UploadRunAttach runUploadAttach(int run_id, int index, File description, File predictions) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        params.addPart("predictions", (ContentBody)new FileBody(predictions));
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/" + run_id + "/" + index);
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof UploadRunAttach) {
            return (UploadRunAttach)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadRunAttach");
    }

    public RunList runList(Map<String, List<Integer>> filters, Integer limit, Integer offset) throws Exception {
        URL request;
        Object apiResult;
        String suffix = "";
        for (String name : filters.keySet()) {
            suffix = suffix + "/" + name + "/" + StringUtils.join((Iterable)filters.get(name), (char)',');
        }
        if (limit != null) {
            suffix = suffix + "/limit/" + limit;
        }
        if (offset != null) {
            suffix = suffix + "/offset/" + offset;
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "run/list" + suffix), this.getApiKey(), this.verboseLevel)) instanceof RunList) {
            return (RunList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunList");
    }

    public EvaluationList evaluationList(List<Integer> task_id, List<Integer> setup_id, String function) throws Exception {
        URL request;
        Object apiResult;
        String suffix = "";
        if (task_id != null) {
            suffix = suffix + "/task/" + StringUtils.join(task_id, (char)',');
        }
        if (setup_id != null) {
            suffix = suffix + "/setup/" + StringUtils.join(setup_id, (char)',');
        }
        if (function != null) {
            suffix = suffix + "/function/" + function;
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "evaluation/list" + suffix), this.getApiKey(), this.verboseLevel)) instanceof EvaluationList) {
            return (EvaluationList)apiResult;
        }
        throw new DataFormatException("Casting Api Object to EvaluationList");
    }

    public EvaluationRequest evaluationRequest(int evaluationEngineId, String mode, Map<String, String> additionalFilters) throws Exception {
        URL request;
        Object apiResult;
        String suffix = "evaluation/request/" + evaluationEngineId + "/" + mode;
        if (additionalFilters != null) {
            for (String filter : additionalFilters.keySet()) {
                suffix = suffix + "/" + filter + "/" + additionalFilters.get(filter);
            }
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + suffix), this.getApiKey(), this.verboseLevel)) instanceof EvaluationRequest) {
            return (EvaluationRequest)apiResult;
        }
        throw new DataFormatException("Casting Api Object to EvaluationRequest");
    }

    public RunTag runTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/tag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunTag) {
            return (RunTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunTag");
    }

    public RunUntag runUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("run_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/untag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunUntag) {
            return (RunUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunUntag");
    }

    public RunEvaluate runEvaluate(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("description", (ContentBody)new FileBody(description));
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/evaluate");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunEvaluate) {
            return (RunEvaluate)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunEvaluate");
    }

    public RunTraceUpload runTraceUpload(File trace) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("trace", (ContentBody)new FileBody(trace));
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/trace");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunTraceUpload) {
            return (RunTraceUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunTraceUpload");
    }

    public RunTrace runTrace(int trace_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/trace/" + trace_id);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunTrace) {
            return (RunTrace)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunTrace");
    }

    public Run runGet(int runId) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/" + runId);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof Run) {
            return (Run)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Run");
    }

    public RunDelete runDelete(int id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/" + id);
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunDelete) {
            return (RunDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunDelete");
    }

    public RunReset runReset(int run_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "run/reset/" + run_id);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof RunReset) {
            return (RunReset)apiResult;
        }
        throw new DataFormatException("Casting Api Object to RunReset");
    }

    public SetupExists setupExists(File description) throws Exception {
        MultipartEntity params = new MultipartEntity();
        if (this.verboseLevel >= 1) {
            System.out.println(Conversion.fileToString(description) + "\n==========");
        }
        params.addPart("description", (ContentBody)new FileBody(description));
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/exists");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupExists) {
            return (SetupExists)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupExists");
    }

    public SetupParameters setupParameters(int setup_id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/" + setup_id);
        Object apiResult = HttpConnector.doApiRequest(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupParameters) {
            return (SetupParameters)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupParameters");
    }

    public SetupTag setupTag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("setup_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/tag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupTag) {
            return (SetupTag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupTag");
    }

    public SetupUntag setupUntag(int id, String tag) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("setup_id", (ContentBody)new StringBody("" + id));
        params.addPart("tag", (ContentBody)new StringBody(tag));
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/untag");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupUntag) {
            return (SetupUntag)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupUntag");
    }

    public SetupDelete setupDelete(int id) throws Exception {
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/" + id);
        Object apiResult = HttpConnector.doApiDelete(request, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupDelete) {
            return (SetupDelete)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDelete");
    }

    public SetupDifferences setupDifferences(int setupA, int setupB, int task_id, int task_size, int differences) throws Exception {
        MultipartEntity params = new MultipartEntity();
        params.addPart("task_id", (ContentBody)new StringBody("" + task_id));
        params.addPart("task_size", (ContentBody)new StringBody("" + task_size));
        params.addPart("differences", (ContentBody)new StringBody("" + differences));
        URL request = new URL(this.OPENML_URL + this.API_PART + "setup/differences/" + setupA + "/" + setupB);
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof SetupDifferences) {
            return (SetupDifferences)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDifferences");
    }

    public SetupDifferences setupDifferences(Integer setupA, Integer setupB, Integer task_id) throws Exception {
        URL request;
        Object apiResult;
        String suffix = setupA + "/" + setupB;
        if (task_id != null) {
            suffix = suffix + "/" + task_id;
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "setup/differences/" + suffix), this.getApiKey(), this.verboseLevel)) instanceof SetupDifferences) {
            return (SetupDifferences)apiResult;
        }
        throw new DataFormatException("Casting Api Object to SetupDifferences");
    }

    public FileUpload fileUpload(File file) throws Exception {
        MultipartEntity params = new MultipartEntity();
        if (this.verboseLevel >= 2) {
            System.out.println(Conversion.fileToString(file) + "\n==========\n");
        }
        params.addPart("file", (ContentBody)new FileBody(file));
        URL request = new URL(this.OPENML_URL + this.API_PART + "file/upload");
        Object apiResult = HttpConnector.doApiRequest(request, params, this.getApiKey(), this.verboseLevel);
        if (apiResult instanceof FileUpload) {
            return (FileUpload)apiResult;
        }
        throw new DataFormatException("Casting Api Object to UploadFile");
    }

    public Job jobRequest(String workbench, String task_type_id) throws Exception {
        return this.jobRequest(workbench, task_type_id, null, null, null);
    }

    public Job jobRequest(String workbench, String task_type_id, String task_tag, String setup_tag, Integer setup_id) throws Exception {
        URL request;
        Object apiResult;
        MultipartEntity params = new MultipartEntity();
        params.addPart("workbench", (ContentBody)new StringBody(workbench));
        params.addPart("task_type_id", (ContentBody)new StringBody(task_type_id));
        if (task_tag != null) {
            params.addPart("task_tag", (ContentBody)new StringBody(task_tag));
        }
        if (setup_tag != null) {
            params.addPart("setup_tag", (ContentBody)new StringBody(setup_tag));
        }
        if (setup_id != null) {
            params.addPart("setup_id", (ContentBody)new StringBody(setup_id + ""));
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "job/request"), params, this.getApiKey(), this.verboseLevel)) instanceof Job) {
            return (Job)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Job");
    }

    public Study studyGet(String studyAlias, String dataType) throws Exception {
        URL request;
        Object apiResult;
        String suffix = "";
        if (dataType != null) {
            suffix = suffix + "/" + dataType;
        }
        if ((apiResult = HttpConnector.doApiRequest(request = new URL(this.OPENML_URL + this.API_PART + "study/" + studyAlias + suffix), this.getApiKey(), this.verboseLevel)) instanceof Study) {
            return (Study)apiResult;
        }
        throw new DataFormatException("Casting Api Object to Study");
    }

    public Study studyGet(int studyId) throws Exception {
        return this.studyGet("" + studyId, null);
    }

    public Study studyGet(int studyId, String dataType) throws Exception {
        return this.studyGet("" + studyId, dataType);
    }

    public URL getOpenmlFileUrl(Integer file_id, String filename) throws Exception {
        if (filename == null) {
            filename = "file";
        }
        String suffix = this.api_key == null ? "" : "?api_key=" + this.getApiKey();
        return new URL(this.OPENML_URL + "data/v1/download/" + file_id + "/" + URLEncoder.encode(filename, "UTF-8") + suffix);
    }
}

