/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openml.apiconnector.algorithms.Conversion;
import org.openml.apiconnector.settings.Constants;
import org.openml.apiconnector.settings.Settings;

public class Config
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean loaded = false;
    private HashMap<String, String> config;

    public Config() {
        try {
            String configfile = Constants.OPENML_DIRECTORY + "/openml.conf";
            this.load(new File(configfile));
        }
        catch (IOException ioe) {
            Conversion.log("Warning", "Load Config", "Could not locate default config file.");
        }
    }

    public Config(String config) {
        this.process(Arrays.asList(config.split(";")));
    }

    public void updateStaticSettings() {
        if (this.get("cache_allowed") != null && this.get("cache_allowed").equals("false")) {
            Settings.CACHE_ALLOWED = false;
        }
        if (this.get("cache_directory") != null) {
            Settings.CACHE_DIRECTORY = this.config.get("cache_directory");
        }
    }

    private void load(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        ArrayList<String> lines = new ArrayList<String>();
        while (br.ready()) {
            lines.add(br.readLine());
        }
        br.close();
        this.process(lines);
    }

    private void process(List<String> lines) {
        this.config = new HashMap();
        this.config.put("server", "https://www.openml.org/");
        for (String line : lines) {
            String[] l = line.split("=");
            if (l.length != 2) continue;
            this.config.put(l[0].trim(), l[1].trim());
        }
        this.loaded = true;
    }

    public String getApiKey() {
        return this.get("api_key");
    }

    public String getServer() {
        return this.get("server");
    }

    public String[] getTags() {
        String result = this.get("tags");
        if (result == null) {
            return new String[0];
        }
        String[] tags = result.split(",");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
        }
        return tags;
    }

    public String getChachePrefixFromUrl() throws MalformedURLException {
        return Config.getChachePrefixFromUrl(new URL(this.getServer()));
    }

    public static String getChachePrefixFromUrl(URL server) throws MalformedURLException {
        String[] host = server.getHost().split("\\.");
        String result = "";
        for (int i = 0; i < host.length; ++i) {
            result = host[i] + "/" + result;
        }
        return result;
    }

    public String get(String key) {
        if (this.loaded && this.config.containsKey(key)) {
            return this.config.get(key);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.config.keySet()) {
            if (s.equals("password")) {
                sb.append(s + "=" + this.config.get(s).length() + "chars; ");
                continue;
            }
            sb.append(s + "=" + this.config.get(s) + "; ");
        }
        return sb.toString();
    }
}

