/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import java.util.Map;
import java.util.TreeMap;

@XStreamAlias(value="oml:data")
public class Data {
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamImplicit
    @XStreamAlias(value="oml:dataset")
    private DataSet[] data;

    public String getOml() {
        return "http://openml.org/openml";
    }

    public DataSet[] getData() {
        return this.data;
    }

    @XStreamAlias(value="oml:dataset")
    public static class DataSet {
        @XStreamAlias(value="oml:did")
        private int did;
        @XStreamAlias(value="oml:name")
        private String name;
        @XStreamAlias(value="oml:version")
        private String version;
        @XStreamAlias(value="oml:status")
        private String status;
        @XStreamAlias(value="oml:format")
        private String format;
        @XStreamAlias(value="oml:file_id")
        private Integer file_id;
        @XStreamImplicit
        @XStreamAlias(value="oml:quality")
        private Quality[] qualities;

        public int getDid() {
            return this.did;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFormat() {
            return this.format;
        }

        public String getStatus() {
            return this.status;
        }

        public Integer getFileId() {
            return this.file_id;
        }

        public Quality[] getQualities() {
            return this.qualities;
        }

        public Map<String, String> getQualityMap() {
            TreeMap<String, String> result = new TreeMap<String, String>();
            if (this.getQualities() != null) {
                for (Quality q : this.getQualities()) {
                    result.put(q.getName(), q.getValue());
                }
            }
            return result;
        }

        @XStreamAlias(value="oml:quality")
        @XStreamConverter(value=ToAttributedValueConverter.class, strings={"value"})
        public static class Quality {
            @XStreamAsAttribute
            @XStreamAlias(value="name")
            private String name;
            private String value;

            public Quality(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

