/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import java.util.HashMap;
import java.util.Map;

public class DataQuality {
    private final String oml = "http://openml.org/openml";
    private Integer did;
    private Integer evaluation_engine_id;
    private String error;
    private Quality[] qualities;

    public DataQuality(Integer did, Integer evaluation_engine_id, Quality[] qualities) {
        this.did = did;
        this.evaluation_engine_id = evaluation_engine_id;
        this.qualities = qualities;
    }

    public DataQuality(Integer did, Integer evaluation_engine_id, String error) {
        this.did = did;
        this.evaluation_engine_id = evaluation_engine_id;
        this.error = error;
    }

    public Integer getDid() {
        return this.did;
    }

    public Integer getEvaluation_engine_id() {
        return this.evaluation_engine_id;
    }

    public String getError() {
        return this.error;
    }

    public Quality[] getQualities() {
        return this.qualities;
    }

    public String[] getQualityNames() {
        String[] result = new String[this.qualities.length];
        for (int i = 0; i < this.qualities.length; ++i) {
            result[i] = this.qualities[i].getName();
        }
        return result;
    }

    public Map<String, String> getQualitiesMap() {
        HashMap<String, String> qm = new HashMap<String, String>();
        for (Quality q : this.qualities) {
            qm.put(q.getName(), q.getValue());
        }
        return qm;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public static class Quality {
        private String name;
        private Integer feature_index;
        private String value;
        private Integer interval_start;
        private Integer interval_end;

        public Quality(String name, String value) {
            this.name = name;
            this.value = value;
            this.feature_index = null;
        }

        public Quality(String name, String value, Integer intervat_start, Integer interval_end, Integer index) {
            this.name = name;
            this.value = value;
            this.interval_start = intervat_start;
            this.interval_end = interval_end;
            this.feature_index = index;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getInterval_start() {
            return this.interval_start;
        }

        public Integer getInterval_end() {
            return this.interval_end;
        }

        public Integer getFeature_index() {
            return this.feature_index;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }
}

