/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.algorithms.ArffHelper;

@XStreamAlias(value="oml:data_set_description")
public class DataSetDescription
implements Serializable {
    private static final long serialVersionUID = 987612341129L;
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamAlias(value="oml:id")
    private Integer id;
    @XStreamAlias(value="oml:name")
    private String name;
    @XStreamAlias(value="oml:version")
    private String version;
    @XStreamAlias(value="oml:description")
    private String description;
    @XStreamAlias(value="oml:format")
    private String format;
    @XStreamImplicit(itemFieldName="oml:creator")
    private String[] creator;
    @XStreamImplicit(itemFieldName="oml:contributor")
    private String[] contributor;
    @XStreamAlias(value="oml:collection_date")
    private String collection_date;
    @XStreamAlias(value="oml:upload_date")
    private String upload_date;
    @XStreamAlias(value="oml:language")
    private String language;
    @XStreamAlias(value="oml:licence")
    private String licence;
    @XStreamAlias(value="oml:url")
    private String url;
    @XStreamAlias(value="oml:file_id")
    private Integer file_id;
    @XStreamAlias(value="oml:default_target_attribute")
    private String default_target_attribute;
    @XStreamAlias(value="oml:row_id_attribute")
    private String row_id_attribute;
    @XStreamImplicit(itemFieldName="ignore_attribute")
    private String[] ignore_attribute;
    @XStreamAlias(value="oml:version_label")
    private String version_label;
    @XStreamImplicit(itemFieldName="oml:tag")
    private String[] tag;
    @XStreamAlias(value="oml:visibility")
    private String visibility;
    @XStreamAlias(value="oml:original_data_url")
    private String original_data_url;
    @XStreamAlias(value="oml:paper_url")
    private String paper_url;
    @XStreamAlias(value="oml:status")
    private String status;
    @XStreamAlias(value="oml:md5_checksum")
    private String md5_checksum;
    @XStreamOmitField
    private File dataset_cache;

    public DataSetDescription(Integer id, String name, String version, String description, String[] creator, String[] contributor, String format, String collection_date, String language, String licence, String url, String row_id_attribute, String default_target_attribute, String[] ignore_attribute, String[] tag, String md5_checksum) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.creator = creator;
        this.contributor = contributor;
        this.format = format;
        this.collection_date = collection_date;
        this.language = language;
        this.upload_date = null;
        this.licence = licence;
        this.url = url;
        this.row_id_attribute = row_id_attribute;
        this.default_target_attribute = default_target_attribute;
        this.ignore_attribute = ignore_attribute;
        this.tag = tag;
        this.md5_checksum = md5_checksum;
    }

    public DataSetDescription(String name, String description, String format, String default_target_attribute) {
        this.id = null;
        this.name = name;
        this.version = null;
        this.description = description;
        this.creator = null;
        this.contributor = null;
        this.format = format;
        this.collection_date = null;
        this.language = null;
        this.upload_date = null;
        this.licence = null;
        this.url = null;
        this.row_id_attribute = null;
        this.default_target_attribute = default_target_attribute;
        this.md5_checksum = null;
    }

    public DataSetDescription(String name, String description, String format, String url, String default_target_attribute) {
        this.id = null;
        this.name = name;
        this.version = null;
        this.description = description;
        this.creator = null;
        this.contributor = null;
        this.format = format;
        this.collection_date = null;
        this.language = null;
        this.upload_date = null;
        this.licence = null;
        this.url = url;
        this.row_id_attribute = null;
        this.default_target_attribute = default_target_attribute;
        this.md5_checksum = null;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getId() {
        return this.id;
    }

    public void unsetId() {
        this.id = null;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getCreator() {
        return this.creator;
    }

    public String[] getContributor() {
        return this.contributor;
    }

    public String getCollection_date() {
        return this.collection_date;
    }

    public String getUpload_date() {
        return this.upload_date;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLicence() {
        return this.licence;
    }

    public String getUrl() {
        return this.url;
    }

    public void unsetUrl() {
        this.url = null;
    }

    public Integer getFile_id() {
        return this.file_id;
    }

    public String getRow_id_attribute() {
        return this.row_id_attribute;
    }

    public String getDefault_target_attribute() {
        return this.default_target_attribute;
    }

    public String getVersion_label() {
        return this.version_label;
    }

    public String[] getIgnore_attribute() {
        return this.ignore_attribute;
    }

    public String[] getTag() {
        return this.tag;
    }

    public void addTag(String new_tag) {
        if (this.tag != null && Arrays.asList(this.tag).contains(new_tag)) {
            return;
        }
        this.tag = (String[])ArrayUtils.addAll((Object[])this.tag, (Object[])new String[]{new_tag});
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getMd5_checksum() {
        return this.md5_checksum;
    }

    public File getDataset(String api_key) throws Exception {
        String url_suffix = "";
        if (api_key != null) {
            url_suffix = "?api_key=" + api_key;
        }
        if (this.dataset_cache == null) {
            this.dataset_cache = ArffHelper.downloadAndCache("dataset", this.getId(), this.getFormat(), new URL(this.getUrl() + url_suffix), this.getMd5_checksum());
        }
        return this.dataset_cache;
    }
}

