/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.openml.apiconnector.algorithms.MathHelper;

public class EvaluationScore {
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamAlias(value="oml:name")
    private final String function;
    @XStreamAlias(value="oml:value")
    private final String value;
    @XStreamAlias(value="oml:stdev")
    private final Double stdev;
    @XStreamAlias(value="oml:array_data")
    private final String array_data;
    @XStreamAlias(value="oml:sample_size")
    private Integer sample_size;
    @XStreamAsAttribute
    @XStreamAlias(value="repeat")
    private final Integer repeat;
    @XStreamAsAttribute
    @XStreamAlias(value="fold")
    private final Integer fold;
    @XStreamAsAttribute
    @XStreamAlias(value="sample")
    private final Integer sample;

    public EvaluationScore(String function, String value, Double stdev, String array_data) {
        this.function = function;
        this.value = value;
        this.stdev = stdev;
        this.array_data = array_data;
        this.repeat = null;
        this.fold = null;
        this.sample = null;
        this.sample_size = null;
    }

    public EvaluationScore(String function, String value, String array_data, Integer repeat, Integer fold) {
        this.function = function;
        this.value = value;
        this.array_data = array_data;
        this.fold = fold;
        this.repeat = repeat;
        this.sample = null;
        this.sample_size = null;
        this.stdev = null;
    }

    public EvaluationScore(String function, String value, String array_data, Integer repeat, Integer fold, Integer sample, Integer sample_size) {
        this.function = function;
        this.value = value;
        this.array_data = array_data;
        this.fold = fold;
        this.repeat = repeat;
        this.sample = sample;
        this.sample_size = sample_size;
        this.stdev = null;
    }

    public String getFunction() {
        return this.function;
    }

    public String getValue() {
        return this.value;
    }

    public double getStdev() {
        return this.stdev;
    }

    public String getArray_data() {
        return this.array_data;
    }

    public Integer getFold() {
        return this.fold;
    }

    public Integer getRepeat() {
        return this.repeat;
    }

    public Integer getSample() {
        return this.sample;
    }

    public void setSample_size(int sample_size) {
        this.sample_size = sample_size;
    }

    public Integer getSample_size() {
        return this.sample_size;
    }

    public boolean isSame(EvaluationScore other) {
        return EvaluationScore.equalStrings(this.function, other.getFunction()) && EvaluationScore.equalIntegers(this.fold, other.getFold()) && EvaluationScore.equalIntegers(this.repeat, other.getRepeat()) && EvaluationScore.equalIntegers(this.sample, other.getSample());
    }

    public boolean sameValue(EvaluationScore other) {
        try {
            double myValue = Double.parseDouble(this.value);
            double otherValue = Double.parseDouble(other.getValue());
            return Math.abs(myValue - otherValue) < MathHelper.EPSILON;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.repeat != null) {
            sb.append(", repeat " + this.repeat);
        }
        if (this.fold != null) {
            sb.append(", fold " + this.fold);
        }
        if (this.sample != null) {
            sb.append(", sample " + this.sample);
        }
        if (sb.length() == 0) {
            sb.append(", GLOBAL");
        }
        return this.function + " - [" + sb.toString().substring(2) + "]";
    }

    private static boolean equalStrings(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    private static boolean equalIntegers(Integer s1, Integer s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }
}

