/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Flow {
    private final String oml = "http://openml.org/openml";
    private Integer id;
    private String fullName;
    private Integer uploader;
    private String name;
    private String custom_name;
    private String class_name;
    private String version;
    private String external_version;
    private String description;
    private String[] creator;
    private String[] contributor;
    private String upload_date;
    private String licence;
    private String language;
    private String full_description;
    private String installation_notes;
    private String dependencies;
    private String implement;
    private Parameter[] parameter;
    private Component[] component;
    private String[] tag;
    private String source_url;
    private String binary_url;
    private String source_format;
    private String binary_format;
    private String source_md5;
    private String binary_md5;

    public Flow(String name, String class_name, String external_version, String description, String language, String dependencies) {
        this.name = name;
        this.class_name = class_name;
        this.external_version = external_version;
        this.description = description;
        this.language = language;
        this.dependencies = dependencies;
    }

    public Flow(String name, String custom_name, String class_name, String external_version, String description, String[] creator, String[] contributor, String licence, String language, String full_description, String installation_notes, String dependencies, String[] tag) {
        this.name = name;
        this.custom_name = custom_name;
        this.class_name = class_name;
        this.external_version = external_version;
        this.description = description;
        this.creator = creator;
        this.contributor = contributor;
        this.licence = licence;
        this.language = language;
        this.full_description = full_description;
        this.installation_notes = installation_notes;
        this.dependencies = dependencies;
        this.tag = tag;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getId() {
        return this.id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCustom_name() {
        return this.custom_name;
    }

    public void setCustom_name(String custom_name) {
        this.custom_name = custom_name;
    }

    public String getClass_name() {
        return this.class_name;
    }

    public void setClass_name(String class_name) {
        this.class_name = class_name;
    }

    public String getExternal_version() {
        return this.external_version;
    }

    public void setExternal_version(String external_version) {
        this.external_version = external_version;
    }

    public Integer getUploader() {
        return this.uploader;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getCreator() {
        return this.creator;
    }

    public String[] getContributor() {
        return this.contributor;
    }

    public String getUpload_date() {
        return this.upload_date;
    }

    public String getLicence() {
        return this.licence;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getFull_description() {
        return this.full_description;
    }

    public String getInstallation_notes() {
        return this.installation_notes;
    }

    public String getDependencies() {
        return this.dependencies;
    }

    public String getImplement() {
        return this.implement;
    }

    public Parameter[] getParameter() {
        return this.parameter;
    }

    public Component[] getComponent() {
        return this.component;
    }

    public String[] getTag() {
        return this.tag;
    }

    public String getSource_url() {
        return this.source_url;
    }

    public String getBinary_url() {
        return this.binary_url;
    }

    public String getSource_format() {
        return this.source_format;
    }

    public String getBinary_format() {
        return this.binary_format;
    }

    public String getSource_md5() {
        return this.source_md5;
    }

    public String getBinary_md5() {
        return this.binary_md5;
    }

    public void addTag(String new_tag) {
        if (this.tag != null && Arrays.asList(this.tag).contains(new_tag)) {
            return;
        }
        this.tag = (String[])ArrayUtils.addAll((Object[])this.tag, (Object[])new String[]{new_tag});
    }

    public void addParameter(String name, String data_type, String default_value, String description) {
        Parameter p = new Parameter(name, data_type, default_value, description);
        this.parameter = (Parameter[])ArrayUtils.addAll((Object[])this.parameter, (Object[])new Parameter[]{p});
    }

    public void addParameter(Parameter p) {
        this.parameter = (Parameter[])ArrayUtils.addAll((Object[])this.parameter, (Object[])new Parameter[]{p});
    }

    public Flow getComponentByName(String name) throws Exception {
        for (Component c : this.getComponent()) {
            if (!c.getImplementation().getName().equals(name)) continue;
            return c.getImplementation();
        }
        throw new Exception("Subimplementation not present.");
    }

    public void addComponent(String identifier, Flow implementation, boolean updateName) {
        Component c = new Component(identifier, implementation);
        this.component = (Component[])ArrayUtils.addAll((Object[])this.component, (Object[])new Component[]{c});
        if (updateName) {
            this.name = this.name + "_" + implementation.getLastName();
        }
    }

    public void addComponent(String identifier, Flow implementation) {
        this.addComponent(identifier, implementation, true);
    }

    public boolean parameter_exists(String name) {
        if (this.parameter != null) {
            for (Parameter p : this.parameter) {
                if (!p.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public Flow getSubImplementation(String identifier) throws Exception {
        if (this.component != null) {
            for (Component p : this.component) {
                if (!p.identifier.equals(identifier)) continue;
                return p.getImplementation();
            }
        }
        throw new Exception("Component with identifier " + identifier + " not found. ");
    }

    public static class Component {
        private String identifier;
        private Flow flow;

        public Component(String identifier, Flow flow) {
            this.identifier = identifier;
            this.flow = flow;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Flow getImplementation() {
            return this.flow;
        }
    }

    public static class Parameter {
        private String name;
        private String data_type;
        private String default_value;
        private String description;

        public Parameter(String name, String data_type, String default_value, String description) {
            this.name = name;
            this.data_type = data_type;
            this.default_value = default_value;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getData_type() {
            return this.data_type;
        }

        public String getDefault_value() {
            return this.default_value;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Bibliographical_reference {
        private String citation;
        private String url;

        public Bibliographical_reference(String citation, String url) {
            this.citation = citation;
            this.url = url;
        }

        public String getCitation() {
            return this.citation;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

