/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.xml.EvaluationScore;

@XStreamAlias(value="oml:run")
public class Run {
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamAlias(value="oml:run_id")
    private Integer run_id;
    @XStreamAlias(value="oml:uploader")
    private Integer uploader;
    @XStreamAlias(value="oml:task_id")
    private Integer task_id;
    @XStreamAlias(value="oml:flow_id")
    private int flow_id;
    @XStreamAlias(value="oml:flow_name")
    private String flow_name;
    @XStreamAlias(value="oml:setup_id")
    private Integer setup_id;
    @XStreamAlias(value="oml:setup_string")
    private String setup_string;
    @XStreamAlias(value="oml:error_message")
    private String error_message;
    @XStreamImplicit(itemFieldName="oml:parameter_setting")
    private Parameter_setting[] parameter_settings;
    @XStreamImplicit(itemFieldName="oml:tag")
    private String[] tag;
    @XStreamAlias(value="oml:input_data")
    private Data input_data;
    @XStreamAlias(value="oml:output_data")
    private Data output_data;

    public Run(Integer task_id, String error_message, int flow_id, String setup_string, Parameter_setting[] parameter_settings, String[] tags) {
        this.task_id = task_id;
        this.flow_id = flow_id;
        this.setup_string = setup_string;
        this.error_message = error_message;
        this.parameter_settings = parameter_settings;
        this.tag = tags;
        this.output_data = new Data();
        this.input_data = new Data();
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public int getRun_id() {
        return this.run_id;
    }

    public int getUploader() {
        return this.uploader;
    }

    public int getTask_id() {
        return this.task_id;
    }

    public int getSetup_id() {
        return this.setup_id;
    }

    public int getFlow_id() {
        return this.flow_id;
    }

    public String getFlow_name() {
        return this.flow_name;
    }

    public String getError_message() {
        return this.error_message;
    }

    public String getSetup_string() {
        return this.setup_string;
    }

    public String[] getTag() {
        return this.tag;
    }

    public Parameter_setting[] getParameter_settings() {
        return this.parameter_settings;
    }

    public void addTag(String new_tag) {
        if (this.tag != null && Arrays.asList(this.tag).contains(new_tag)) {
            return;
        }
        this.tag = (String[])ArrayUtils.addAll((Object[])this.tag, (Object[])new String[]{new_tag});
    }

    public void addInputData(String name, String url) {
        this.input_data.addDataset(name, url);
    }

    public void addOutputData(String name, String url) {
        this.output_data.addDataset(name, url);
    }

    public void addOutputEvaluation(EvaluationScore e) {
        this.output_data.addEvaluation(e);
    }

    public EvaluationScore[] getOutputEvaluation() {
        if (this.output_data == null) {
            return null;
        }
        return this.output_data.evaluation;
    }

    public Data.File[] getOutputFile() {
        return this.output_data.file;
    }

    public Map<String, Data.File> getOutputFileAsMap() {
        TreeMap<String, Data.File> result = new TreeMap<String, Data.File>();
        if (this.output_data != null) {
            for (Data.File f : this.output_data.file) {
                result.put(f.name, f);
            }
        }
        return result;
    }

    public static class Data {
        @XStreamImplicit(itemFieldName="oml:dataset")
        private Dataset[] dataset = new Dataset[0];
        @XStreamImplicit(itemFieldName="oml:file")
        private File[] file;
        @XStreamImplicit(itemFieldName="oml:evaluation")
        private EvaluationScore[] evaluation = new EvaluationScore[0];

        public Dataset[] getDataset() {
            return this.dataset;
        }

        public File[] file() {
            return this.file;
        }

        public EvaluationScore[] getEvaluation() {
            return this.evaluation;
        }

        public void addDataset(String name, String url) {
            Dataset d = new Dataset(name, url);
            this.dataset = (Dataset[])ArrayUtils.addAll((Object[])this.dataset, (Object[])new Dataset[]{d});
        }

        public void addEvaluation(EvaluationScore score) {
            this.evaluation = (EvaluationScore[])ArrayUtils.addAll((Object[])this.evaluation, (Object[])new EvaluationScore[]{score});
        }

        public static class File {
            @XStreamAlias(value="oml:did")
            private Integer did;
            @XStreamAlias(value="oml:file_id")
            private Integer file_id;
            @XStreamAlias(value="oml:name")
            private String name;
            @XStreamAlias(value="oml:format")
            private String format;
            @XStreamAlias(value="oml:upload_time")
            private String uploadTime;
            @XStreamAlias(value="oml:url")
            private String url;

            public int getDid() {
                return this.did;
            }

            public int getFileId() {
                return this.file_id;
            }

            public String getName() {
                return this.name;
            }

            public String getUrl() {
                return this.url;
            }

            public String getFormat() {
                return this.format;
            }

            public String getUploadTime() {
                return this.uploadTime;
            }
        }

        public static class Dataset {
            @XStreamAlias(value="oml:did")
            private Integer did;
            @XStreamAlias(value="oml:name")
            private String name;
            @XStreamAlias(value="oml:url")
            private String url;

            public Dataset(String name, String url) {
                this.name = name;
                this.url = url;
            }

            public int getDid() {
                return this.did;
            }

            public String getName() {
                return this.name;
            }

            public String getUrl() {
                return this.url;
            }
        }
    }

    public static class Parameter_setting {
        @XStreamAlias(value="oml:name")
        private String name;
        @XStreamAlias(value="oml:value")
        private String value;
        @XStreamAlias(value="oml:component")
        private Integer component;

        public Parameter_setting(Integer component, String name, String value) {
            this.name = name;
            this.component = component;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getComponent() {
            return this.component;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.component + "_" + this.name + ": " + this.value;
        }
    }
}

