/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import org.apache.commons.lang3.ArrayUtils;
import org.openml.apiconnector.xml.EvaluationScore;

@XStreamAlias(value="oml:run_evaluation")
public class RunEvaluation {
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamAlias(value="oml:run_id")
    private Integer run_id;
    @XStreamAlias(value="oml:evaluation_engine_id")
    private Integer evaluation_engine_id;
    @XStreamAlias(value="oml:error")
    private String error;
    @XStreamAlias(value="oml:warning")
    private String warning;
    @XStreamImplicit(itemFieldName="oml:evaluation")
    private EvaluationScore[] evaluation;

    public RunEvaluation(int run_id, int evaluation_engine_id) {
        this.run_id = run_id;
        this.evaluation_engine_id = evaluation_engine_id;
        this.error = null;
        this.warning = null;
    }

    public void addEvaluationMeasures(EvaluationScore[] em) {
        this.evaluation = (EvaluationScore[])ArrayUtils.addAll((Object[])this.evaluation, (Object[])em);
    }

    public void addEvaluationMeasure(EvaluationScore em) {
        this.evaluation = (EvaluationScore[])ArrayUtils.addAll((Object[])this.evaluation, (Object[])new EvaluationScore[]{em});
    }

    public void setError(String error, int max_length) {
        String truncateMessage = "... (message cut-off due to excessive length)";
        this.error = error.length() <= max_length ? error : error.substring(0, max_length - truncateMessage.length()) + truncateMessage;
    }

    public void setWarning(String warning, int max_length) {
        String truncateMessage = "... (message cut-off due to excessive length)";
        this.warning = warning.length() <= max_length ? warning : warning.substring(0, max_length - truncateMessage.length()) + truncateMessage;
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getRun_id() {
        return this.run_id;
    }

    public String getError() {
        return this.error;
    }

    public String getWarning() {
        return this.warning;
    }

    public EvaluationScore[] getEvaluation_scores() {
        return this.evaluation;
    }
}

