/*
 * Decompiled with CFR 0.152.
 */
package org.openml.apiconnector.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.openml.apiconnector.algorithms.ArffHelper;
import org.openml.apiconnector.algorithms.OptionParser;
import org.openml.apiconnector.io.HttpConnector;
import org.openml.apiconnector.io.OpenmlConnector;
import org.openml.apiconnector.settings.Settings;
import org.openml.apiconnector.xml.DataSetDescription;

@XStreamAlias(value="oml:task")
public class Task
implements Serializable {
    private static final long serialVersionUID = 987612341009L;
    @XStreamAsAttribute
    @XStreamAlias(value="xmlns:oml")
    private final String oml = "http://openml.org/openml";
    @XStreamAlias(value="oml:task_id")
    private Integer task_id;
    @XStreamAlias(value="oml:task_name")
    private String task_name;
    @XStreamAlias(value="oml:task_type_id")
    private Integer task_type_id;
    @XStreamAlias(value="oml:task_type")
    private String task_type;
    @XStreamImplicit(itemFieldName="oml:input")
    private Input[] inputs;
    @XStreamImplicit(itemFieldName="oml:output")
    private Output[] outputs;
    @XStreamImplicit(itemFieldName="oml:tag")
    private String[] tag;

    public Task(int id) {
        this.task_id = id;
    }

    public Task(int id, String inputName1, Integer data_set_id, String target_feature, String inputName2, String data_splits_url, HashMap<String, String> parameters) {
        this.task_id = id;
        Input firstInput = new Input(inputName1, data_set_id, target_feature);
        Input secondInput = new Input(inputName2, data_splits_url, parameters);
        this.inputs = new Input[2];
        this.inputs[0] = firstInput;
        this.inputs[1] = secondInput;
    }

    public String toString() {
        return this.task_name;
    }

    public boolean equals(Object other) {
        return other instanceof Task && ((Task)other).getTask_id() == this.getTask_id();
    }

    public String getOml() {
        return "http://openml.org/openml";
    }

    public Integer getTask_id() {
        return this.task_id;
    }

    public String getTask_name() {
        return this.task_name;
    }

    public Integer getTask_type_id() {
        return this.task_type_id;
    }

    public String getTask_type() {
        return this.task_type;
    }

    public Input[] getInputs() {
        return this.inputs;
    }

    public Map<String, Input> getInputsAsMap() {
        TreeMap<String, Input> result = new TreeMap<String, Input>();
        for (Input i : this.inputs) {
            result.put(i.getName(), i);
        }
        return result;
    }

    public Output[] getOutputs() {
        return this.outputs;
    }

    public String[] getTags() {
        return this.tag;
    }

    public class Output
    implements Serializable {
        private static final long serialVersionUID = 987612341059L;
        @XStreamAsAttribute
        private String name;
        @XStreamAlias(value="oml:predictions")
        private Predictions predictions;

        public String getName() {
            return this.name;
        }

        public Predictions getPredictions() {
            return this.predictions;
        }

        public class Predictions
        implements Serializable {
            private static final long serialVersionUID = 987612341069L;
            @XStreamAlias(value="oml:format")
            private String format;
            @XStreamImplicit(itemFieldName="oml:feature")
            private Feature[] features;

            public String getFormat() {
                return this.format;
            }

            public Feature[] getFeatures() {
                return this.features;
            }

            @XStreamAlias(value="oml:feature")
            public class Feature
            implements Serializable {
                private static final long serialVersionUID = 987612341079L;
                @XStreamAsAttribute
                private String name;
                @XStreamAsAttribute
                private String type;

                public String getName() {
                    return this.name;
                }

                public String getType() {
                    return this.type;
                }
            }
        }
    }

    public class Input
    implements Serializable {
        private static final long serialVersionUID = 987612341019L;
        @XStreamAsAttribute
        private String name;
        @XStreamAlias(value="oml:data_set")
        private Data_set data_set;
        @XStreamAlias(value="oml:stream_schedule")
        private Stream_schedule stream_schedule;
        @XStreamAlias(value="oml:estimation_procedure")
        private Estimation_procedure estimation_procedure;
        @XStreamAlias(value="oml:cost_matrix")
        private String cost_matrix;
        @XStreamAlias(value="oml:evaluation_meaures")
        private Evaluation_measures evaluation_measures;
        @XStreamAlias(value="oml:time_limit")
        private Double time_limit;
        @XStreamAlias(value="oml:quality_measure")
        private String quality_measure;

        public Input(String name, Integer datasetId, String targetFeature) {
            this.name = name;
            this.data_set = new Data_set(datasetId, targetFeature);
        }

        public Input(String name, String data_splits_url, HashMap<String, String> parameters) {
            this.name = name;
            this.estimation_procedure = new Estimation_procedure(data_splits_url, parameters);
        }

        public String getName() {
            return this.name;
        }

        public Data_set getData_set() {
            return this.data_set;
        }

        public Stream_schedule getStream_schedule() {
            return this.stream_schedule;
        }

        public Double getTime_limit() {
            return this.time_limit;
        }

        public String getQuality_measure() {
            return this.quality_measure;
        }

        public double[][] getCost_Matrix() throws Exception {
            if (this.cost_matrix != null && !this.cost_matrix.equals("")) {
                return OptionParser.stringToArray(this.cost_matrix);
            }
            return null;
        }

        public Estimation_procedure getEstimation_procedure() {
            return this.estimation_procedure;
        }

        public Evaluation_measures getEvaluation_measures() {
            return this.evaluation_measures;
        }

        public class Evaluation_measures
        implements Serializable {
            private static final long serialVersionUID = 987612341049L;
            @XStreamImplicit(itemFieldName="oml:evaluation_measure")
            private String[] evaluation_measure;

            public String[] getEvaluation_measure() {
                return this.evaluation_measure;
            }
        }

        @XStreamAlias(value="oml:estimation_procedure")
        public class Estimation_procedure
        implements Serializable {
            private static final long serialVersionUID = 987612341039L;
            @XStreamAlias(value="oml:type")
            private String type;
            @XStreamAlias(value="oml:data_splits_url")
            private String data_splits_url;
            @XStreamImplicit(itemFieldName="oml:parameter")
            private Parameter[] parameters;
            @XStreamOmitField
            private File data_splits_cache;

            public Estimation_procedure(String data_splits_url, HashMap<String, String> parameterList) {
                int size = parameterList.size();
                this.parameters = new Parameter[size];
                this.data_splits_url = data_splits_url;
                Iterator<String> keysIterator = parameterList.keySet().iterator();
                int counter = 0;
                while (keysIterator.hasNext()) {
                    String key = keysIterator.next();
                    this.parameters[counter] = new Parameter(key, parameterList.get(key));
                    ++counter;
                }
            }

            public String getType() {
                return this.type;
            }

            public String getData_splits_url() {
                return this.data_splits_url;
            }

            public Parameter[] getParameters() {
                return this.parameters;
            }

            public File getDataSplits(int task_id) throws Exception {
                if (this.data_splits_cache == null) {
                    String serverMd5 = null;
                    if (Settings.LOCAL_OPERATIONS) {
                        serverMd5 = HttpConnector.getStringFromUrl(new URL(this.getData_splits_url().replace("/get/", "/md5/")), false);
                    }
                    this.data_splits_cache = ArffHelper.downloadAndCache("splits", task_id, "arff", new URL(this.getData_splits_url()), serverMd5);
                }
                return this.data_splits_cache;
            }

            @XStreamConverter(value=ToAttributedValueConverter.class, strings={"value"})
            public class Parameter
            implements Serializable {
                private static final long serialVersionUID = 987612341099L;
                private String name;
                private String value;

                public Parameter(String parameterName, String value) {
                    this.name = parameterName;
                    this.value = value;
                }

                public String getName() {
                    return this.name;
                }

                public String getValue() {
                    return this.value;
                }
            }
        }

        @XStreamAlias(value="oml:stream_schedule")
        public class Stream_schedule
        implements Serializable {
            private static final long serialVersionUID = -4788645256661953298L;
            @XStreamAlias(value="oml:train_url")
            private URL train_url;
            @XStreamAlias(value="oml:test_url")
            private URL test_url;
            @XStreamAlias(value="oml:start_time")
            private String start_time;
            @XStreamAlias(value="oml:initial_batch_size")
            private Integer initial_batch_size;
            @XStreamAlias(value="oml:batch_size")
            private Integer batch_size;
            @XStreamAlias(value="oml:batch_time")
            private Integer batch_time;

            public URL getTrain_url() {
                return this.train_url;
            }

            public URL getTest_url() {
                return this.test_url;
            }

            public String getStart_time() {
                return this.start_time;
            }

            public Integer getInitial_batch_size() {
                return this.initial_batch_size;
            }

            public Integer getBatch_size() {
                return this.batch_size;
            }

            public Integer getBatch_time() {
                return this.batch_time;
            }

            public String toString() {
                return "[" + this.start_time + "; init: " + this.initial_batch_size + "; size: " + this.batch_size + "; time: " + this.batch_time + "]";
            }
        }

        @XStreamAlias(value="oml:data_set")
        public class Data_set
        implements Serializable {
            private static final long serialVersionUID = 987612341029L;
            @XStreamAlias(value="oml:data_set_id")
            private Integer data_set_id;
            @XStreamAlias(value="oml:labeled_data_set_id")
            private Integer labeled_data_set_id;
            @XStreamAlias(value="oml:target_feature")
            private String target_feature;
            @XStreamAlias(value="oml:target_feature_left")
            private String target_feature_left;
            @XStreamAlias(value="oml:target_feature_right")
            private String target_feature_right;
            @XStreamAlias(value="oml:target_feature_event")
            private String target_feature_event;
            @XStreamAlias(value="oml:target_value")
            private String target_value;
            @XStreamOmitField
            private DataSetDescription dsdCache;

            public Data_set(Integer data_set_id, String target_feature) {
                this.data_set_id = data_set_id;
                this.target_feature = target_feature;
            }

            public Integer getData_set_id() {
                return this.data_set_id;
            }

            public Integer getLabeled_data_set_id() {
                return this.labeled_data_set_id;
            }

            public String getTarget_feature() {
                return this.target_feature;
            }

            public String getTarget_feature_left() {
                return this.target_feature_left;
            }

            public String getTarget_feature_right() {
                return this.target_feature_right;
            }

            public String getTarget_feature_event() {
                return this.target_feature_event;
            }

            public String getTarget_value() {
                return this.target_value;
            }

            public DataSetDescription getDataSetDescription(OpenmlConnector apiconnector) throws Exception {
                if (this.dsdCache == null) {
                    this.dsdCache = apiconnector.dataGet(this.data_set_id);
                }
                return this.dsdCache;
            }
        }
    }
}

